/*
 * Decompiled with CFR 0.152.
 */
package de.lise.fluxflow.springboot.scheduling.quartz;

import de.lise.fluxflow.api.job.CancellationKey;
import de.lise.fluxflow.api.workflow.WorkflowIdentifier;
import de.lise.fluxflow.scheduling.SchedulingCallback;
import de.lise.fluxflow.scheduling.SchedulingReference;
import de.lise.fluxflow.scheduling.SchedulingService;
import de.lise.fluxflow.springboot.scheduling.quartz.QuartzScheduledJob;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/lise/fluxflow/springboot/scheduling/quartz/QuartzSchedulingService;", "Lde/lise/fluxflow/scheduling/SchedulingService;", "scheduler", "Lorg/quartz/Scheduler;", "clock", "Ljava/time/Clock;", "(Lorg/quartz/Scheduler;Ljava/time/Clock;)V", "listeners", "", "Lde/lise/fluxflow/scheduling/SchedulingCallback;", "cancel", "", "workflowIdentifier", "Lde/lise/fluxflow/api/workflow/WorkflowIdentifier;", "cancellationKey", "Lde/lise/fluxflow/api/job/CancellationKey;", "createJobMetadata", "Lorg/quartz/JobDetail;", "pointInTime", "Ljava/time/Instant;", "schedulingReference", "Lde/lise/fluxflow/scheduling/SchedulingReference;", "createTrigger", "Lorg/quartz/Trigger;", "notify", "ref", "registerListener", "callback", "schedule", "springboot-quartz"})
@SourceDebugExtension(value={"SMAP\nQuartzSchedulingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuartzSchedulingService.kt\nde/lise/fluxflow/springboot/scheduling/quartz/QuartzSchedulingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1855#2,2:82\n*S KotlinDebug\n*F\n+ 1 QuartzSchedulingService.kt\nde/lise/fluxflow/springboot/scheduling/quartz/QuartzSchedulingService\n*L\n75#1:82,2\n*E\n"})
public class QuartzSchedulingService
implements SchedulingService {
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final Clock clock;
    @NotNull
    private final List<SchedulingCallback> listeners;

    public QuartzSchedulingService(@NotNull Scheduler scheduler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.scheduler = scheduler;
        this.clock = clock;
        this.listeners = new ArrayList();
    }

    @NotNull
    protected JobDetail createJobMetadata(@NotNull Instant pointInTime, @NotNull SchedulingReference schedulingReference) {
        Intrinsics.checkNotNullParameter((Object)pointInTime, (String)"pointInTime");
        Intrinsics.checkNotNullParameter((Object)schedulingReference, (String)"schedulingReference");
        JobBuilder builder = null;
        builder = JobBuilder.newJob(QuartzScheduledJob.class).usingJobData("jobIdentifier", schedulingReference.getJobIdentifier().getValue()).usingJobData("workflowIdentifier", schedulingReference.getWorkflowIdentifier().getValue());
        CancellationKey cancellationKey = schedulingReference.getCancellationKey();
        if (cancellationKey != null) {
            CancellationKey it = cancellationKey;
            boolean bl = false;
            builder = builder.withIdentity(it.getValue(), schedulingReference.getWorkflowIdentifier().getValue());
        }
        JobDetail jobDetail = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jobDetail, (String)"build(...)");
        return jobDetail;
    }

    @NotNull
    protected Trigger createTrigger(@NotNull Instant pointInTime, @NotNull SchedulingReference schedulingReference) {
        Intrinsics.checkNotNullParameter((Object)pointInTime, (String)"pointInTime");
        Intrinsics.checkNotNullParameter((Object)schedulingReference, (String)"schedulingReference");
        Trigger trigger = TriggerBuilder.newTrigger().startAt(Date.from(pointInTime)).build();
        Intrinsics.checkNotNullExpressionValue((Object)trigger, (String)"build(...)");
        return trigger;
    }

    public void schedule(@NotNull Instant pointInTime, @NotNull SchedulingReference schedulingReference) {
        Intrinsics.checkNotNullParameter((Object)pointInTime, (String)"pointInTime");
        Intrinsics.checkNotNullParameter((Object)schedulingReference, (String)"schedulingReference");
        if (pointInTime.compareTo(this.clock.instant()) <= 0) {
            this.notify(schedulingReference);
            return;
        }
        JobDetail job = this.createJobMetadata(pointInTime, schedulingReference);
        Trigger trigger = this.createTrigger(pointInTime, schedulingReference);
        this.scheduler.scheduleJob(job, trigger);
    }

    public void cancel(@NotNull WorkflowIdentifier workflowIdentifier, @NotNull CancellationKey cancellationKey) {
        Intrinsics.checkNotNullParameter((Object)workflowIdentifier, (String)"workflowIdentifier");
        Intrinsics.checkNotNullParameter((Object)cancellationKey, (String)"cancellationKey");
        this.scheduler.deleteJob(JobKey.jobKey((String)cancellationKey.getValue(), (String)workflowIdentifier.getValue()));
    }

    public void registerListener(@NotNull SchedulingCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.listeners.add(callback);
    }

    public final void notify(@NotNull SchedulingReference ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SchedulingCallback listener = (SchedulingCallback)element$iv;
            boolean bl = false;
            listener.onScheduled(ref);
        }
    }
}

