/*
 * Decompiled with CFR 0.152.
 */
package de.lise.fluxflow.springboot.autoconfigure;

import de.lise.fluxflow.api.step.StepService;
import de.lise.fluxflow.api.workflow.WorkflowService;
import de.lise.fluxflow.engine.step.StepActivationService;
import de.lise.fluxflow.springboot.cache.memory.step.MemoryCachingStepActivationService;
import de.lise.fluxflow.springboot.cache.memory.step.MemoryCachingStepService;
import de.lise.fluxflow.springboot.cache.memory.step.StepCache;
import de.lise.fluxflow.springboot.cache.memory.workflow.MemoryCachingWorkflowService;
import de.lise.fluxflow.springboot.cache.memory.workflow.WorkflowCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(value={"fluxflow.caching.in-memory"}, havingValue="true", matchIfMissing=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017\u00a8\u0006\u0010"}, d2={"Lde/lise/fluxflow/springboot/autoconfigure/MemoryCachingConfiguration;", "", "()V", "cachedStepActivationService", "Lde/lise/fluxflow/engine/step/StepActivationService;", "stepActivationService", "stepCache", "Lde/lise/fluxflow/springboot/cache/memory/step/StepCache;", "cachedStepService", "Lde/lise/fluxflow/api/step/StepService;", "stepService", "cachedWorkflowService", "Lde/lise/fluxflow/api/workflow/WorkflowService;", "workflowService", "workflowCache", "Lde/lise/fluxflow/springboot/cache/memory/workflow/WorkflowCache;", "memorycache"})
public class MemoryCachingConfiguration {
    @Bean
    @NotNull
    public WorkflowCache workflowCache() {
        return new WorkflowCache();
    }

    @Bean
    @Primary
    @NotNull
    public WorkflowService cachedWorkflowService(@NotNull WorkflowService workflowService, @NotNull WorkflowCache workflowCache) {
        Intrinsics.checkNotNullParameter((Object)workflowService, (String)"workflowService");
        Intrinsics.checkNotNullParameter((Object)workflowCache, (String)"workflowCache");
        return new MemoryCachingWorkflowService(workflowService, workflowCache);
    }

    @Bean
    @NotNull
    public StepCache stepCache() {
        return new StepCache();
    }

    @Bean
    @Primary
    @NotNull
    public StepService cachedStepService(@NotNull StepService stepService, @NotNull StepCache stepCache) {
        Intrinsics.checkNotNullParameter((Object)stepService, (String)"stepService");
        Intrinsics.checkNotNullParameter((Object)stepCache, (String)"stepCache");
        return new MemoryCachingStepService(stepService, stepCache);
    }

    @Bean
    @Primary
    @NotNull
    public StepActivationService cachedStepActivationService(@NotNull StepActivationService stepActivationService, @NotNull StepCache stepCache) {
        Intrinsics.checkNotNullParameter((Object)stepActivationService, (String)"stepActivationService");
        Intrinsics.checkNotNullParameter((Object)stepCache, (String)"stepCache");
        return new MemoryCachingStepActivationService(stepActivationService, stepCache);
    }
}

