/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.version;

import de.linusdev.lutils.other.UnknownConstantException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ReleaseType {
    DEVELOPMENT_BUILD("dev"),
    EARLY_ACCESS("early-access"),
    RELEASE(null),
    SNAPSHOT("snapshot"),
    CLOSED_ALPHA("closed-alpha"),
    CLOSED_BETA("closed-beta"),
    ALPHA("alpha"),
    BETA("beta");

    @Nullable
    private final String appendix;

    @NotNull
    public static ReleaseType ofAppendix(@Nullable String appendix) {
        if (appendix == null) {
            return RELEASE;
        }
        for (ReleaseType type : ReleaseType.values()) {
            if (type.appendix == null || !type.appendix.equals(appendix)) continue;
            return type;
        }
        throw new UnknownConstantException((Object)appendix);
    }

    private ReleaseType(String appendix) {
        this.appendix = appendix;
    }

    @Nullable
    public String appendix() {
        return this.appendix;
    }
}

