/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.routing.builder;

import de.linusdev.lutils.net.http.method.Methods;
import de.linusdev.lutils.net.http.method.RequestMethod;
import de.linusdev.lutils.net.routing.RequestHandler;
import de.linusdev.lutils.net.routing.Route;
import de.linusdev.lutils.net.routing.builder.RouteBuilderParent;
import de.linusdev.lutils.net.routing.builder.RoutingBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RouteBuilder<PARENT>
implements RouteBuilderParent {
    @NotNull
    private final HashMap<RequestMethod, RequestHandler> handlers = new HashMap();
    @Nullable
    private RequestHandler defaultHandler;
    @NotNull
    private final HashMap<String, RouteBuilder<?>> routes = new HashMap();
    @Nullable
    private RouteBuilder<RouteBuilder<PARENT>> defaultRoute;
    private boolean defaultRouteIsSelf = false;
    @NotNull
    private final RoutingBuilder routingBuilder;
    @NotNull
    private final PARENT parent;

    public RouteBuilder(@NotNull RoutingBuilder routingBuilder, @NotNull PARENT parent) {
        this.routingBuilder = routingBuilder;
        this.parent = parent;
    }

    public RouteBuilder<PARENT> GET(@NotNull RequestHandler handler) {
        this.handlers.put(Methods.GET, handler);
        return this;
    }

    @SafeVarargs
    public final <T> RouteBuilder<PARENT> routes(@NotNull Function<T, String> routePath, @NotNull BiConsumer<T, RouteBuilder<?>> route, T ... params) {
        for (T param : params) {
            RouteBuilder<RouteBuilder<PARENT>> builder = this.route(routePath.apply(param));
            route.accept(param, builder);
            builder.buildRoute();
        }
        return this;
    }

    public RouteBuilder<PARENT> defaultHandler(@Nullable RequestHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
        return this;
    }

    @NotNull
    public RouteBuilder<RouteBuilder<PARENT>> route(@NotNull String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path cannot be empty.");
        }
        RouteBuilder<RouteBuilder<PARENT>> builder = new RouteBuilder<RouteBuilder<PARENT>>(this.routingBuilder, this);
        this.routes.put(path, builder);
        return builder;
    }

    @NotNull
    public RouteBuilder<RouteBuilder<PARENT>> defaultRoute() {
        this.defaultRoute = new RouteBuilder<RouteBuilder>(this.routingBuilder, this);
        this.defaultRoute.setDefaultRouteIsSelf(true);
        return this.defaultRoute;
    }

    void setDefaultRouteIsSelf(boolean defaultRouteIsSelf) {
        this.defaultRouteIsSelf = defaultRouteIsSelf;
    }

    @NotNull
    Route getRoute() {
        HashMap<String, Route> routes = new HashMap<String, Route>(this.routes.size());
        for (Map.Entry<String, RouteBuilder<?>> route : this.routes.entrySet()) {
            routes.put(route.getKey(), route.getValue().getRoute());
        }
        if (this.defaultRouteIsSelf) {
            return new Route(true, routes, this.handlers, this.defaultHandler);
        }
        return new Route(this.defaultRoute == null ? null : this.defaultRoute.getRoute(), routes, this.handlers, this.defaultHandler);
    }

    public PARENT buildRoute() {
        return this.parent;
    }
}

