/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http.version;

import de.linusdev.lutils.net.http.version.HTTPVersion;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum HTTPVersions implements HTTPVersion
{
    HTTP_0_9("0.9"),
    HTTP_1_0("1.0", "1"),
    HTTP_1_1("1.1"),
    HTTP_2_0("2.0", "2"),
    HTTP_3_0("3.0", "3");

    private static final Map<String, HTTPVersions> versions;
    @NotNull
    private final @NotNull String @NotNull [] version;

    public static HTTPVersion of(@NotNull String version) {
        return versions.get(version);
    }

    private HTTPVersions(String ... version) {
        this.version = version;
    }

    @Override
    @NotNull
    public String getName() {
        return "HTTP";
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version[0];
    }

    static {
        versions = new HashMap<String, HTTPVersions>(HTTPVersions.values().length);
        for (HTTPVersions v : HTTPVersions.values()) {
            for (String version : v.version) {
                versions.put(v.getName() + "/" + version, v);
            }
        }
    }
}

