/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http;

import de.linusdev.lutils.net.http.HTTPMessage;
import de.linusdev.lutils.net.http.HTTPMessageBuilder;
import de.linusdev.lutils.net.http.HTTPMessageReader;
import de.linusdev.lutils.net.http.body.Bodies;
import de.linusdev.lutils.net.http.body.Body;
import de.linusdev.lutils.net.http.body.BodyParser;
import de.linusdev.lutils.net.http.header.HeaderMap;
import de.linusdev.lutils.net.http.status.ResponseStatusCode;
import de.linusdev.lutils.net.http.status.StatusCodes;
import de.linusdev.lutils.net.http.version.HTTPVersion;
import de.linusdev.lutils.net.http.version.HTTPVersions;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTTPResponse<B>
extends HTTPMessage<B> {
    @NotNull
    private final ResponseStatusCode statusCode;

    @NotNull
    public static <B> HTTPResponse<B> parse(@NotNull InputStream in, @NotNull BodyParser<B> parser) throws IOException {
        HTTPMessageReader reader = new HTTPMessageReader(in);
        HTTPMessageReader.LineReader lineReader = reader.getLineReader();
        HTTPVersion version = HTTPVersions.of(lineReader.readUntil(' '));
        if (lineReader.eol) {
            throw new IllegalArgumentException("Malformed HTTP request. Missing status code.");
        }
        String code = lineReader.readUntil(' ');
        String reasonPhrase = lineReader.eol ? "" : lineReader.readUntilLineFeed();
        ResponseStatusCode statusCode = ResponseStatusCode.of(code, reasonPhrase);
        HeaderMap headers = HTTPResponse.parseHeaders(reader);
        B body = parser.parse(headers, reader.getInputStreamForRemaining());
        return new HTTPResponse<B>(version, statusCode, headers, body);
    }

    @NotNull
    public static HTTPResponse<InputStream> parse(@NotNull InputStream in) throws IOException {
        return HTTPResponse.parse(in, (hs, in1) -> in1);
    }

    @NotNull
    public static HTTPMessageBuilder builder() {
        return new HTTPMessageBuilder();
    }

    @NotNull
    public static PrefabricatedResponses responses() {
        return new PrefabricatedResponses();
    }

    protected HTTPResponse(@NotNull HTTPVersion version, @NotNull ResponseStatusCode statusCode, @NotNull HeaderMap headers, @Nullable B body) {
        super(version, headers, body);
        this.statusCode = statusCode;
    }

    @NotNull
    public ResponseStatusCode getStatusCode() {
        return this.statusCode;
    }

    public static class PrefabricatedResponses {
        @NotNull
        public HTTPMessageBuilder badRequest(@Nullable String reason) {
            HTTPMessageBuilder builder = HTTPResponse.builder().setStatusCode(StatusCodes.BAD_REQUEST);
            if (reason != null) {
                builder.setBody(Bodies.textUtf8().ofStringUtf8(reason));
            }
            return builder;
        }

        @NotNull
        public HTTPMessageBuilder badRequest() {
            return this.badRequest(null);
        }

        @NotNull
        public HTTPMessageBuilder ok(@Nullable Body body) {
            HTTPMessageBuilder builder = HTTPResponse.builder().setStatusCode(StatusCodes.OK);
            if (body != null) {
                builder.setBody(body);
            }
            return builder;
        }

        @NotNull
        public HTTPMessageBuilder ok() {
            return this.ok(null);
        }
    }
}

