/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.string;

import de.linusdev.lutils.nat.array.NativeInt8Array;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.SVWrapper;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullTerminatedUTF8String
extends NativeInt8Array {
    protected final byte @Nullable [] defaultValue;

    public static NullTerminatedUTF8String newUnallocated() {
        return new NullTerminatedUTF8String(null, false, null);
    }

    public static NullTerminatedUTF8String newAllocatable(@NotNull StructValue structValue) {
        return new NullTerminatedUTF8String(structValue, true, null);
    }

    public static NullTerminatedUTF8String newAllocated(@NotNull StructValue structValue) {
        NullTerminatedUTF8String ret = NullTerminatedUTF8String.newAllocatable(structValue);
        ret.allocate();
        return ret;
    }

    public static NullTerminatedUTF8String newAllocatable(@NotNull String defaultValue) {
        byte[] bytes = defaultValue.getBytes(StandardCharsets.UTF_8);
        return new NullTerminatedUTF8String((StructValue)SVWrapper.length(bytes.length + 1), true, bytes);
    }

    public static NullTerminatedUTF8String newAllocated(@NotNull String string) {
        NullTerminatedUTF8String natString = NullTerminatedUTF8String.newAllocatable(string);
        natString.allocate();
        return natString;
    }

    protected NullTerminatedUTF8String(@Nullable StructValue structValue, boolean generateInfo, byte @Nullable [] defaultValue) {
        super(structValue, generateInfo);
        this.defaultValue = defaultValue;
    }

    @Override
    protected void useBuffer(@NotNull Structure mostParentStructure, int offset, @NotNull StructureInfo info) {
        super.useBuffer(mostParentStructure, offset, info);
        if (this.defaultValue != null) {
            this.set(this.defaultValue);
        }
    }

    public void set(@NotNull String value) {
        this.byteBuf.clear();
        this.byteBuf.put(value.getBytes(StandardCharsets.UTF_8));
        this.byteBuf.put((byte)0);
        this.byteBuf.clear();
    }

    @Override
    public void set(byte @NotNull [] value) {
        super.set(value);
        this.byteBuf.put(value.length, (byte)0);
    }

    @NotNull
    public String get() {
        this.byteBuf.clear();
        byte[] bytes = new byte[this.length()];
        this.byteBuf.get(bytes);
        int index = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            index = i;
            break;
        }
        return new String(bytes, 0, index, StandardCharsets.UTF_8);
    }

    @Override
    public String toString() {
        return this.toString("utf-8-string", this.get());
    }
}

