/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileCollector
implements FileVisitor<Path> {
    @NotNull
    private final @NotNull BiPredicate<@NotNull Path, @NotNull BasicFileAttributes> collectPredicate;
    @NotNull
    private final @NotNull List<@NotNull Path> collectedFiles = new ArrayList<Path>();

    public FileCollector(@NotNull @NotNull BiPredicate<@NotNull Path, @NotNull BasicFileAttributes> collectPredicate) {
        this.collectPredicate = collectPredicate;
    }

    @NotNull
    public @NotNull List<@NotNull Path> getCollectedFiles() {
        return this.collectedFiles;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (this.collectPredicate.test(file, attrs)) {
            this.collectedFiles.add(file);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) {
        return FileVisitResult.CONTINUE;
    }
}

