/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.wip_webp.reader;

import de.linusdev.lutils.image.wip_webp.reader.BitReader;
import de.linusdev.lutils.image.wip_webp.reader.WebPImageType;
import de.linusdev.lutils.image.wip_webp.reader.WebPReaderException;
import de.linusdev.lutils.image.wip_webp.reader.WebReaderUtils;
import de.linusdev.lutils.image.wip_webp.reader.simple.lossless.SimpleLosslessWebP;
import de.linusdev.lutils.io.InputStreamUtils;
import de.linusdev.lutils.nat.EndianUtils;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class WebPReader {
    public void read(@NotNull InputStream in) throws WebPReaderException {
        try {
            byte[] headerAndFirstChunkHeader = new byte[20];
            if (!InputStreamUtils.readUntilArrayIsFull(in, headerAndFirstChunkHeader)) {
                throw new WebPReaderException("File too short.");
            }
            int readingPos = 0;
            if (!WebReaderUtils.checkChunkFourCC(headerAndFirstChunkHeader, 0, WebReaderUtils.RIFF)) {
                throw new WebPReaderException("First webp header fourCC should be RIFF, but is '" + WebReaderUtils.convertChunkFourCC(headerAndFirstChunkHeader, 0) + "'.");
            }
            int fileSize = EndianUtils.littleEndianBytesToInt(headerAndFirstChunkHeader, readingPos += 4);
            if (!WebReaderUtils.checkChunkFourCC(headerAndFirstChunkHeader, readingPos += 4, WebReaderUtils.WEBP)) {
                throw new WebPReaderException("Second webp header fourCC should be WEBP, but is '" + WebReaderUtils.convertChunkFourCC(headerAndFirstChunkHeader, readingPos) + "'.");
            }
            int actualFileSize = fileSize + 4 + 4;
            WebPImageType type = WebPImageType.of(headerAndFirstChunkHeader, readingPos += 4);
            readingPos += 4;
            if (type == WebPImageType.SIMPLE_LOSSY) {
                throw new WebPReaderException("Webp of type simple-lossy is not supported.");
            }
            if (type == WebPImageType.SIMPLE_LOSSLESS) {
                int chunkSize = EndianUtils.littleEndianBytesToInt(headerAndFirstChunkHeader, readingPos);
                byte[] chunk = new byte[chunkSize];
                if (!InputStreamUtils.readUntilArrayIsFull(in, chunk)) {
                    throw new WebPReaderException("Webp missing chunk data.");
                }
                BitReader reader = new BitReader(chunk);
                SimpleLosslessWebP.read(reader);
            }
        }
        catch (IOException e) {
            throw new WebPReaderException(e);
        }
    }
}

