/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.parser;

import de.linusdev.lutils.html.HtmlUtils;
import de.linusdev.lutils.html.parser.AttributeReader;
import de.linusdev.lutils.html.parser.HtmlParserState;
import de.linusdev.lutils.result.BiResult;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public class HtmlReader {
    @NotNull
    private final Reader reader;
    private final char[] pushBackBuffer = new char[1024];
    private int pushBackIndex = 0;

    public HtmlReader(@NotNull Reader reader) {
        this.reader = reader;
    }

    public boolean canRead() throws IOException {
        if (this.pushBackIndex != 0) {
            return true;
        }
        int r = this.reader.read();
        if (r == -1) {
            return false;
        }
        this.pushBack((char)r);
        return true;
    }

    public char read() throws IOException {
        if (this.pushBackIndex != 0) {
            return this.pushBackBuffer[--this.pushBackIndex];
        }
        int r = this.reader.read();
        if (r == -1) {
            throw new EOFException();
        }
        return (char)r;
    }

    public char skipNewLinesAndSpaces() throws IOException {
        char r;
        while ((r = this.read()) == '\n' || r == ' ') {
        }
        return r;
    }

    public char skipNewLinesAndFollowingSpaces() throws IOException {
        char r = this.read();
        if (r == '\n') {
            while ((r = this.read()) == '\n') {
            }
            if (r == ' ') {
                while ((r = this.read()) == ' ') {
                }
            }
            if (r == '\n') {
                return this.skipNewLinesAndFollowingSpaces();
            }
        }
        return r;
    }

    public boolean availableSkipNewLinesAndSpaces() throws IOException {
        if (!this.canRead()) {
            return false;
        }
        char r = '\u0000';
        while (this.canRead()) {
            char c = this.read();
            r = c;
            if (c == '\n' || r == ' ') continue;
        }
        if (r == '\n' || r == ' ') {
            return false;
        }
        this.pushBack(r);
        return true;
    }

    @NotNull
    public String readUntil(char c) throws IOException {
        char r;
        StringBuilder sb = new StringBuilder();
        while ((r = this.read()) != c) {
            sb.append(r);
        }
        return sb.toString();
    }

    @NotNull
    public String readEscapedUntil(char c) throws IOException {
        char r;
        HtmlUtils.Unescaper unescaper = new HtmlUtils.Unescaper();
        while ((r = this.read()) != c) {
            unescaper.append(r);
        }
        return unescaper.getString();
    }

    @NotNull
    public BiResult<String, Character> readEscapedUntil(char c1, char c2) throws IOException {
        char r;
        HtmlUtils.Unescaper unescaper = new HtmlUtils.Unescaper();
        while ((r = this.read()) != c1 && r != c2) {
            unescaper.append(r);
        }
        return new BiResult<String, Character>(unescaper.getString(), Character.valueOf(r));
    }

    @NotNull
    public BiResult<String, Character> readUntil(char c1, char c2) throws IOException {
        char r;
        StringBuilder sb = new StringBuilder();
        while ((r = this.read()) != c1 && r != c2) {
            sb.append(r);
        }
        return new BiResult<String, Character>(sb.toString(), Character.valueOf(r));
    }

    @NotNull
    public BiResult<String, Character> readUntil(char c1, char c2, char c3) throws IOException {
        char r;
        StringBuilder sb = new StringBuilder();
        while ((r = this.read()) != c1 && r != c2 && r != c3) {
            sb.append(r);
        }
        return new BiResult<String, Character>(sb.toString(), Character.valueOf(r));
    }

    @NotNull
    public BiResult<String, Character> readUntil(char c1, char c2, char c3, char c4) throws IOException {
        char r;
        StringBuilder sb = new StringBuilder();
        while ((r = this.read()) != c1 && r != c2 && r != c3 && r != c4) {
            sb.append(r);
        }
        return new BiResult<String, Character>(sb.toString(), Character.valueOf(r));
    }

    public void skip(int n) throws IOException {
        if (this.pushBackIndex != 0) {
            if (this.pushBackIndex >= n) {
                this.pushBackIndex -= n;
            } else {
                this.pushBackIndex = 0;
                this.skip(n -= this.pushBackIndex);
            }
            return;
        }
        if (this.reader.skip(n) != (long)n) {
            throw new EOFException();
        }
    }

    public void pushBack(char c) {
        this.pushBackBuffer[this.pushBackIndex++] = c;
    }

    public void pushBack(char[] c, int len) {
        for (int i = len - 1; i >= 0; --i) {
            this.pushBackBuffer[this.pushBackIndex++] = c[i];
        }
    }

    public void pushBack(@NotNull String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            this.pushBackBuffer[this.pushBackIndex++] = string.charAt(i);
        }
    }

    public String readString() throws IOException {
        char r = this.read();
        if (r == '\"') {
            return this.readEscapedUntil('\"');
        }
        if (r == '\'') {
            return this.readEscapedUntil('\'');
        }
        BiResult<String, Character> res = this.readEscapedUntil(' ', '>');
        this.pushBack(res.result2().charValue());
        return res.result1();
    }

    @NotNull
    public AttributeReader getAttributeReader(@NotNull HtmlParserState state) {
        return new AttributeReader(this, state);
    }

    public void debug() throws IOException {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (this.canRead() && this.pushBackIndex + i < this.pushBackBuffer.length) {
            char r = this.read();
            ++i;
            sb.append(r);
        }
        this.pushBack(sb.toString());
        System.out.println("Remaining:");
        for (String s : sb.toString().split("\n")) {
            System.out.println(s);
        }
    }
}

