/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.lhtml.skeleton;

import de.linusdev.lutils.html.HtmlElement;
import de.linusdev.lutils.html.HtmlElementType;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectType;
import de.linusdev.lutils.html.impl.HtmlPage;
import de.linusdev.lutils.html.impl.element.StandardHtmlElementTypes;
import de.linusdev.lutils.html.lhtml.LhtmlHead;
import de.linusdev.lutils.html.lhtml.LhtmlPage;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholder;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholderAttribute;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholderElement;
import de.linusdev.lutils.html.lhtml.LhtmlTemplateElement;
import de.linusdev.lutils.html.lhtml.skeleton.LhtmlSkeleton;
import de.linusdev.lutils.html.lhtml.skeleton.LhtmlTemplateSkeleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class LhtmlPageSkeleton
implements LhtmlSkeleton {
    @NotNull
    protected final HtmlPage actual;
    @NotNull
    protected final Map<String, LhtmlTemplateSkeleton> templates;

    @ApiStatus.Internal
    @NotNull
    public static LhtmlPage createCopy(@NotNull HtmlPage actual, Map<String, LhtmlTemplateSkeleton> templates) {
        HtmlPage copy = actual.copy();
        HashMap<String, LhtmlPlaceholder> placeholders = new HashMap<String, LhtmlPlaceholder>();
        HashMap<String, String> replaceValues = new HashMap<String, String>();
        AtomicReference head = new AtomicReference();
        AtomicReference body = new AtomicReference();
        Consumer<HtmlObject> consumer = object -> {
            if (object.type() == HtmlObjectType.ELEMENT) {
                HtmlElement element = object.asHtmlElement();
                element.iterateAttributes(attribute -> {
                    if (attribute instanceof LhtmlPlaceholderAttribute) {
                        LhtmlPlaceholderAttribute placeholderAttr = (LhtmlPlaceholderAttribute)attribute;
                        placeholderAttr.setReplaceValues(replaceValues);
                    }
                });
                if (element instanceof LhtmlPlaceholderElement) {
                    LhtmlPlaceholderElement placeholderEle = (LhtmlPlaceholderElement)element;
                    LhtmlPlaceholder holder = placeholders.computeIfAbsent(placeholderEle.getId(), LhtmlPlaceholder::new);
                    holder.addPlaceholderElement(placeholderEle);
                }
                if (HtmlElementType.equals(StandardHtmlElementTypes.BODY, element.tag())) {
                    body.set(element);
                } else if (element instanceof LhtmlHead) {
                    LhtmlHead lhtmlHead = (LhtmlHead)element;
                    head.set(lhtmlHead);
                }
            }
        };
        copy.iterateContentRecursive(consumer);
        assert (head.get() != null);
        assert (body.get() != null);
        return new LhtmlPage(copy, placeholders, templates, replaceValues, (LhtmlHead)head.get(), (HtmlElement)body.get());
    }

    public LhtmlPageSkeleton(@NotNull HtmlPage actual, @NotNull Map<String, LhtmlTemplateSkeleton> templates) {
        this.actual = actual;
        this.templates = templates;
    }

    @Override
    @NotNull
    public LhtmlTemplateElement getTemplate(@NotNull String id) {
        return Objects.requireNonNull(this.templates.get(id)).copy();
    }

    @Override
    @NotNull
    public LhtmlPage copy() {
        return LhtmlPageSkeleton.createCopy(this.actual, this.templates);
    }

    @Override
    @NotNull
    public String getId() {
        return "page";
    }
}

