/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.color.creator;

import de.linusdev.lutils.color.Color;
import de.linusdev.lutils.color.creator.ColorCreator;
import java.util.Iterator;
import java.util.Random;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedColorCreator
implements ColorCreator {
    private final int count;
    @NotNull
    private final @NotNull IntFunction<@NotNull Color> indexToColor;

    public IndexedColorCreator(int count, @NotNull @NotNull IntFunction<@NotNull Color> indexToColor) {
        this.count = count;
        this.indexToColor = indexToColor;
    }

    @Override
    @NotNull
    public Color getRandomColor(@Nullable Random random) {
        if (random == null) {
            random = new Random();
        }
        return this.indexToColor.apply(random.nextInt(this.count));
    }

    @Override
    @NotNull
    public Iterator<Color> iterator() {
        return new Iterator<Color>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < IndexedColorCreator.this.count;
            }

            @Override
            public Color next() {
                return IndexedColorCreator.this.indexToColor.apply(this.index++);
            }
        };
    }
}

