/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.async.executable;

import de.linusdev.lutils.async.AbstractFuture;
import de.linusdev.lutils.async.ComputationResult;
import de.linusdev.lutils.async.consumer.ResultConsumer;
import de.linusdev.lutils.async.executable.ExecutableTask;
import de.linusdev.lutils.async.manager.HasAsyncManager;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableFuture<R, S, T extends ExecutableTask<R, S>>
extends AbstractFuture<R, S, T>
implements HasAsyncManager {
    public ExecutableFuture(@NotNull T task) {
        super(task, task.getAsyncManager());
    }

    public boolean isExecutable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ComputationResult<R, S> executeHere() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDone() || this.hasStarted()) {
                return this.get();
            }
            if (this.isCanceled()) {
                return null;
            }
            this.started = true;
        }
        try {
            Consumer before = this.before;
            if (before != null) {
                before.accept(this);
            }
        }
        catch (Throwable t) {
            this.getAsyncManager().onExceptionInListener(this, this.task, t);
        }
        Object t = this.lock;
        synchronized (t) {
            if (this.isCanceled()) {
                return null;
            }
        }
        assert (this.task != null);
        @NotNull ComputationResult<R, S> result = ((ExecutableTask)this.task).execute();
        Object object2 = this.lock;
        synchronized (object2) {
            this.result = result;
            this.done = true;
            if (this.isCanceled()) {
                return result;
            }
            this.lock.notifyAll();
        }
        try {
            ResultConsumer then = this.then;
            if (then != null) {
                if (result.getResult() != null) {
                    then.consume(result.getResult(), result.getSecondary());
                } else {
                    then.onError(result.getError(), this.task, result.getSecondary());
                }
            }
        }
        catch (Throwable t2) {
            this.getAsyncManager().onExceptionInListener(this, this.task, t2);
        }
        return result;
    }
}

