/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.version;

import de.linusdev.lutils.version.ReleaseType;
import de.linusdev.lutils.version.SimpleVersion;
import de.linusdev.lutils.version.VersionImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Version
extends Comparable<Version> {
    @NotNull
    public static final Pattern VERSION_PATTERN = Pattern.compile("((?<prefix>.+)-)?(?<version>\\d+.\\d+.\\d+)(-(?<postfix>[^-:]+))?(:(?<typeAppendix>.+))?");

    @NotNull
    public static Version of(@NotNull ReleaseType type, int major, int minor, int patch) {
        return Version.of(type, SimpleVersion.of(major, minor, patch), null, null);
    }

    @NotNull
    public static Version of(@NotNull ReleaseType type, @NotNull String simpleVersion) {
        return Version.of(type, SimpleVersion.of(simpleVersion), null, null);
    }

    @NotNull
    public static Version of(@NotNull ReleaseType type, @NotNull SimpleVersion simpleVersion, @Nullable String prefix, @Nullable String postfix) {
        return new VersionImpl(type, simpleVersion, prefix, postfix);
    }

    @NotNull
    public static Version of(@NotNull String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.find()) {
            throw new IllegalStateException("Illegal version '" + version + "'");
        }
        return Version.of(ReleaseType.ofAppendix(matcher.group("typeAppendix")), SimpleVersion.of(matcher.group("version")), matcher.group("prefix"), matcher.group("postfix"));
    }

    @NotNull
    public ReleaseType type();

    @NotNull
    public SimpleVersion version();

    @Nullable
    public String prefix();

    @Nullable
    public String postfix();

    @NotNull
    default public String getAsUserFriendlyString() {
        String prefix = this.prefix() == null ? "" : this.prefix() + "-";
        String postfix = this.postfix() == null ? "" : "-" + this.postfix();
        String typeAppendix = this.type().appendix() == null ? "" : ":" + this.type().appendix();
        return prefix + this.version().getAsUserFriendlyString() + postfix + typeAppendix;
    }

    @NotNull
    default public String getAsArchiveReadyString() {
        String prefix = this.prefix() == null ? "" : this.prefix() + "-";
        String postfix = this.postfix() == null ? "" : "-" + this.postfix();
        String typeAppendix = this.type().appendix() == null ? "" : "_" + this.type().appendix();
        return prefix + this.version().getAsUserFriendlyString() + postfix + typeAppendix;
    }

    public static boolean equals(@Nullable Version that, @Nullable Object other) {
        if (that == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (that == null) {
            return false;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version otherVersion = (Version)other;
        return that.getAsUserFriendlyString().equals(otherVersion.getAsUserFriendlyString());
    }

    @Override
    default public int compareTo(@NotNull Version other) {
        int v = this.version().compareTo(other.version()) * 2;
        if (v == 0) {
            if (this.type() == ReleaseType.RELEASE && other.type() != ReleaseType.RELEASE) {
                return 1;
            }
            if (this.type() != ReleaseType.RELEASE && other.type() == ReleaseType.RELEASE) {
                return -1;
            }
        }
        return v;
    }
}

