/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.ws;

import de.linusdev.lutils.net.http.HTTPMessageBuilder;
import de.linusdev.lutils.net.http.HTTPRequest;
import de.linusdev.lutils.net.http.HTTPResponse;
import de.linusdev.lutils.net.http.body.Bodies;
import de.linusdev.lutils.net.http.body.UnparsedBody;
import de.linusdev.lutils.net.http.header.Header;
import de.linusdev.lutils.net.http.header.HeaderMap;
import de.linusdev.lutils.net.http.header.HeaderName;
import de.linusdev.lutils.net.http.header.HeaderNames;
import de.linusdev.lutils.net.http.header.value.BasicHeaderValue;
import de.linusdev.lutils.net.http.header.value.IntegerHeaderValue;
import de.linusdev.lutils.net.http.method.Methods;
import de.linusdev.lutils.net.http.method.RequestMethod;
import de.linusdev.lutils.net.http.status.StatusCodes;
import de.linusdev.lutils.net.routing.RoutingState;
import de.linusdev.lutils.net.routing.RoutingStateHandler;
import de.linusdev.lutils.net.ws.WebSocket;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSocketServer
implements RoutingStateHandler {
    public static final int SUPPORTED_WEBSOCKET_VERSION = 13;
    @NotNull
    public static final String MAGIC_STRING = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    @NotNull
    private final MessageDigest hashAlgo = MessageDigest.getInstance("SHA-1");
    @NotNull
    private final Consumer<WebSocket> createdWebsocketConsumer;

    @NotNull
    protected static String calculateResponseKey(@NotNull String key, @NotNull MessageDigest hashAlgo) {
        String responseKey = key + MAGIC_STRING;
        byte[] hashed = hashAlgo.digest(responseKey.getBytes(StandardCharsets.ISO_8859_1));
        return Base64.getEncoder().encodeToString(hashed);
    }

    public WebSocketServer(@NotNull Consumer<WebSocket> createdWebsocketConsumer) throws NoSuchAlgorithmException {
        this.createdWebsocketConsumer = createdWebsocketConsumer;
    }

    @Override
    @Nullable
    public HTTPMessageBuilder handle(@NotNull RoutingState state) throws IOException {
        HTTPRequest<UnparsedBody> request = state.getRequest();
        HeaderMap headers = request.getHeaders();
        if (!RequestMethod.equals(Methods.GET, request.getMethod())) {
            return HTTPResponse.builder().setStatusCode(StatusCodes.BAD_REQUEST);
        }
        Header upgradeHeader = headers.get(HeaderNames.UPGRADE);
        if (upgradeHeader == null || !upgradeHeader.getValue().equals("websocket")) {
            return HTTPResponse.builder().setStatusCode(StatusCodes.BAD_REQUEST).setBody(Bodies.textUtf8().ofStringUtf8("Missing or wrong '" + HeaderNames.UPGRADE + "' header."));
        }
        Header connHeader = headers.get(HeaderNames.CONNECTION);
        if (connHeader == null || !connHeader.parseValue(BasicHeaderValue.PARSER).contains("Upgrade")) {
            return HTTPResponse.builder().setStatusCode(StatusCodes.BAD_REQUEST).setBody(Bodies.textUtf8().ofStringUtf8("Missing or wrong '" + HeaderNames.CONNECTION + "' header."));
        }
        Header key = headers.get(HeaderNames.SEC_WEBSOCKET_KEY);
        Integer version = headers.get(HeaderNames.SEC_WEBSOCKET_VERSION).parseValue(IntegerHeaderValue.PARSER);
        if (version != 13) {
            return HTTPResponse.builder().setStatusCode(StatusCodes.BAD_REQUEST).setHeader((HeaderName)HeaderNames.SEC_WEBSOCKET_VERSION, "13");
        }
        String hashedKey = WebSocketServer.calculateResponseKey(key.getValue(), this.hashAlgo);
        Socket socket = state.getSocket();
        if (socket == null) {
            throw new IllegalStateException("A socket is required to create a web socket");
        }
        HTTPResponse.builder().setStatusCode(StatusCodes.SWITCHING_PROTOCOLS).setHeader((HeaderName)HeaderNames.SEC_WEBSOCKET_ACCEPT, hashedKey).setHeader((HeaderName)HeaderNames.UPGRADE, "websocket").setHeader((HeaderName)HeaderNames.CONNECTION, "Upgrade").buildResponse(socket.getOutputStream());
        WebSocket webSocket = new WebSocket(socket, false, false);
        this.createdWebsocketConsumer.accept(webSocket);
        state.handled();
        return null;
    }
}

