/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http.status;

import de.linusdev.lutils.net.http.status.ResponseStatusCode;
import de.linusdev.lutils.net.http.status.ResponseStatusCodeType;
import org.jetbrains.annotations.NotNull;

public enum StatusCodes implements ResponseStatusCode
{
    SWITCHING_PROTOCOLS(101, "Switching Protocols", ResponseStatusCodeType.INFORMATION),
    OK(200, "OK", ResponseStatusCodeType.SUCCESSFUL),
    CREATED(201, "Created", ResponseStatusCodeType.SUCCESSFUL),
    NO_CONTENT(204, "No Content", ResponseStatusCodeType.SUCCESSFUL),
    MOVED_PERMANENTLY(301, "Moved Permanently", ResponseStatusCodeType.REDIRECT),
    TEMPORARY_REDIRECT(307, "Temporary Redirect", ResponseStatusCodeType.REDIRECT),
    PERMANENT_REDIRECT(208, "Permanent Redirect", ResponseStatusCodeType.REDIRECT),
    BAD_REQUEST(400, "Bad Request", ResponseStatusCodeType.CLIENT_ERROR),
    UNAUTHORIZED(401, "Unauthorized", ResponseStatusCodeType.CLIENT_ERROR),
    FORBIDDEN(403, "Forbidden", ResponseStatusCodeType.CLIENT_ERROR),
    NOT_FOUND(404, "Not Found", ResponseStatusCodeType.CLIENT_ERROR),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed", ResponseStatusCodeType.CLIENT_ERROR),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error", ResponseStatusCodeType.SERVER_ERROR),
    NOT_IMPLEMENTED(501, "Not Implemented", ResponseStatusCodeType.SERVER_ERROR),
    BAD_GATEWAY(502, "Bad Gateway", ResponseStatusCodeType.SERVER_ERROR);

    @NotNull
    private final String name;
    private final int statusCode;
    @NotNull
    private final ResponseStatusCodeType type;

    private StatusCodes(@NotNull int statusCode, String name, ResponseStatusCodeType type) {
        this.name = name;
        this.statusCode = statusCode;
        this.type = type;
    }

    @Override
    @NotNull
    public ResponseStatusCodeType getType() {
        return this.type;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    static {
        for (StatusCodes statusCode : StatusCodes.values()) {
            STATUS_CODES.put(statusCode.getStatusCode(), statusCode);
        }
    }
}

