/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http.header.contenttype;

import de.linusdev.lutils.net.http.header.contenttype.ContentType;
import de.linusdev.lutils.net.http.header.value.BasicHeaderValue;
import de.linusdev.lutils.net.http.header.value.BasicHeaderValueImpl;
import de.linusdev.lutils.net.http.header.value.parameters.BasicHeaderValueWithCharset;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentTypes
extends BasicHeaderValueImpl
implements ContentType {
    ContentTypes(@NotNull String name) {
        super(name);
    }

    public static class Image
    extends ContentTypes
    implements BasicHeaderValue {
        @Contract(value=" -> new")
        @NotNull
        public static Image png() {
            return new Image("png");
        }

        protected Image(@NotNull String name) {
            super("image/" + name);
        }
    }

    public static class Text
    extends ContentTypes
    implements BasicHeaderValueWithCharset {
        @Contract(value=" -> new")
        @NotNull
        public static Text html() {
            return new Text("html");
        }

        @Contract(value=" -> new")
        @NotNull
        public static Text plain() {
            return new Text("plain");
        }

        @Contract(value=" -> new")
        @NotNull
        public static Text csv() {
            return new Text("csv");
        }

        @Contract(value=" -> new")
        @NotNull
        public static Text css() {
            return new Text("css");
        }

        @Contract(value=" -> new")
        @NotNull
        public static Text js() {
            return new Text("javascript");
        }

        protected Text(@NotNull String name) {
            super("text/" + name);
        }

        @Override
        @NotNull
        public Text setCharset(@Nullable String charset) {
            BasicHeaderValueWithCharset.super.setCharset(charset);
            return this;
        }
    }
}

