/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.array;

import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.array.NativePrimitiveTypeArray;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class NativeInt32Array
extends NativePrimitiveTypeArray<Integer> {
    public static NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator GENERATOR = new NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator(NativeType.INT32);

    public static NativeInt32Array newUnallocated() {
        return new NativeInt32Array(null, false);
    }

    public static NativeInt32Array newAllocatable(@NotNull StructValue structValue) {
        return new NativeInt32Array(structValue, true);
    }

    public static NativeInt32Array newAllocated(@NotNull StructValue structValue) {
        NativeInt32Array ret = NativeInt32Array.newAllocatable(structValue);
        ret.allocate();
        return ret;
    }

    protected NativeInt32Array(@Nullable StructValue structValue, boolean generateInfo) {
        super(structValue, generateInfo, GENERATOR);
    }

    @Override
    public Integer get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.getInt(index);
    }

    public int getInt(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.byteBuf.getInt(this.positions.position(index));
    }

    @Override
    public void set(int index, Integer item) {
        this.setInt(index, item);
    }

    public void setInt(int index, int item) {
        this.byteBuf.putInt(this.positions.position(index), item);
    }
}

