/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math;

import de.linusdev.lutils.math.LMath;
import de.linusdev.lutils.math.matrix.Matrix;
import de.linusdev.lutils.math.matrix.abstracts.floatn.Float3x3;
import de.linusdev.lutils.math.matrix.abstracts.floatn.Float4x4;
import de.linusdev.lutils.math.matrix.abstracts.floatn.FloatMxN;
import de.linusdev.lutils.math.matrix.abstracts.floatn.min.MinFloat3x3;
import de.linusdev.lutils.math.matrix.abstracts.floatn.min.MinFloat4x4;
import de.linusdev.lutils.math.matrix.array.floatn.ABFloat4x4;
import de.linusdev.lutils.math.vector.UnsignedVector;
import de.linusdev.lutils.math.vector.Vector;
import de.linusdev.lutils.math.vector.abstracts.floatn.Float3;
import de.linusdev.lutils.math.vector.abstracts.floatn.Float4;
import de.linusdev.lutils.math.vector.abstracts.floatn.FloatN;
import de.linusdev.lutils.math.vector.abstracts.intn.IntN;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class VMath {
    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V add(@NotNull V left, @NotNull V right, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(left, right, store));
        assert (VMath.uniqueViewVector(store, left, right));
        for (int i = 0; i < left.getMemberCount(); ++i) {
            store.put(i, left.get(i) + right.get(i));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V subtract(@NotNull V left, @NotNull V right, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(left, right, store));
        assert (VMath.uniqueViewVector(store, left, right));
        for (int i = 0; i < left.getMemberCount(); ++i) {
            store.put(i, left.get(i) - right.get(i));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V multiply(@NotNull V left, @NotNull V right, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(left, right, store));
        assert (VMath.uniqueViewVector(store, left, right));
        for (int i = 0; i < left.getMemberCount(); ++i) {
            store.put(i, left.get(i) * right.get(i));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V divide(@NotNull V left, @NotNull V right, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(left, right, store));
        assert (VMath.uniqueViewVector(store, left, right));
        for (int i = 0; i < left.getMemberCount(); ++i) {
            store.put(i, left.get(i) / right.get(i));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V scale(@NotNull V toScale, float factor, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(toScale, store));
        assert (VMath.uniqueViewVector(store, toScale));
        for (int i = 0; i < toScale.getMemberCount(); ++i) {
            store.put(i, toScale.get(i) * factor);
        }
        return store;
    }

    public static float dot(@NotNull FloatN left, @NotNull FloatN right) {
        assert (VMath.matchingDimensions(left, right));
        float dot = 0.0f;
        for (int i = 0; i < left.getMemberCount(); ++i) {
            dot += left.get(i) * right.get(i);
        }
        return dot;
    }

    public static float length(@NotNull FloatN vector) {
        float length = 0.0f;
        for (int i = 0; i < vector.getMemberCount(); ++i) {
            length += vector.get(i) * vector.get(i);
        }
        return (float)Math.sqrt(length);
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static Float3 cross(@NotNull Float3 left, @NotNull Float3 right, @NotNull Float3 store) {
        float storeX = left.get(1) * right.get(2) - left.get(2) * right.get(1);
        float storeY = left.get(2) * right.get(0) - left.get(0) * right.get(2);
        float storeZ = left.get(0) * right.get(1) - left.get(1) * right.get(0);
        store.xyz(storeX, storeY, storeZ);
        return store;
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static <V extends FloatN> V normalize(@NotNull V toNormalize, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(toNormalize, store));
        assert (VMath.uniqueViewVector(store, toNormalize));
        float length = VMath.length(toNormalize);
        if (length == 0.0f || length == 1.0f) {
            for (int i = 0; i < toNormalize.getMemberCount(); ++i) {
                store.put(i, toNormalize.get(i));
            }
            return store;
        }
        for (int i = 0; i < toNormalize.getMemberCount(); ++i) {
            store.put(i, toNormalize.get(i) / length);
        }
        return store;
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static <V extends FloatN> V absolute(@NotNull V toAbsolute, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(toAbsolute, store));
        assert (VMath.uniqueViewVector(store, toAbsolute));
        for (int i = 0; i < toAbsolute.getMemberCount(); ++i) {
            store.put(i, Math.abs(toAbsolute.get(i)));
        }
        return store;
    }

    @NotNull
    public static <V extends IntN> V min(@NotNull V first, @NotNull V second, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(first, second, store));
        assert (VMath.uniqueViewVector(store, first, second));
        for (int i = 0; i < first.getMemberCount(); ++i) {
            store.put(i, Math.min(first.get(i), second.get(i)));
        }
        return store;
    }

    @NotNull
    public static <V extends IntN> V max(@NotNull V first, @NotNull V second, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(first, second, store));
        assert (VMath.uniqueViewVector(store, first, second));
        for (int i = 0; i < first.getMemberCount(); ++i) {
            store.put(i, Math.max(first.get(i), second.get(i)));
        }
        return store;
    }

    @NotNull
    public static <V extends IntN> V clamp(@NotNull V value, @NotNull V min, @NotNull V max, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(value, min, max, store));
        assert (VMath.uniqueViewVector(store, value, min, max));
        for (int i = 0; i < value.getMemberCount(); ++i) {
            store.put(i, LMath.clamp(value.get(i), min.get(i), max.get(i)));
        }
        return store;
    }

    @NotNull
    public static <V extends FloatN> V min(@NotNull V first, @NotNull V second, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(first, second, store));
        assert (VMath.uniqueViewVector(store, first, second));
        for (int i = 0; i < first.getMemberCount(); ++i) {
            store.put(i, Math.min(first.get(i), second.get(i)));
        }
        return store;
    }

    @NotNull
    public static <V extends FloatN> V max(@NotNull V first, @NotNull V second, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(first, second, store));
        assert (VMath.uniqueViewVector(store, first, second));
        for (int i = 0; i < first.getMemberCount(); ++i) {
            store.put(i, Math.max(first.get(i), second.get(i)));
        }
        return store;
    }

    @NotNull
    public static <V extends FloatN> V clamp(@NotNull V value, @NotNull V min, @NotNull V max, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(value, min, max, store));
        assert (VMath.uniqueViewVector(store, value, min, max));
        for (int i = 0; i < value.getMemberCount(); ++i) {
            store.put(i, LMath.clamp(value.get(i), min.get(i), max.get(i)));
        }
        return store;
    }

    @NotNull
    public static <V extends IntN & UnsignedVector> V minUnsigned(@NotNull V first, @NotNull V second, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(first, second, store));
        assert (VMath.uniqueViewVector(store, first, second));
        for (int i = 0; i < first.getMemberCount(); ++i) {
            store.put(i, LMath.minUnsigned(first.get(i), second.get(i)));
        }
        return store;
    }

    @NotNull
    public static <V extends IntN & UnsignedVector> V maxUnsigned(@NotNull V first, @NotNull V second, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(first, second, store));
        assert (VMath.uniqueViewVector(store, first, second));
        for (int i = 0; i < first.getMemberCount(); ++i) {
            store.put(i, LMath.maxUnsigned(first.get(i), second.get(i)));
        }
        return store;
    }

    @NotNull
    public static <V extends IntN & UnsignedVector> V clampUnsigned(@NotNull V value, @NotNull V min, @NotNull V max, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(value, min, max, store));
        assert (VMath.uniqueViewVector(store, value, min, max));
        for (int i = 0; i < value.getMemberCount(); ++i) {
            store.put(i, LMath.clampUnsigned(value.get(i), min.get(i), max.get(i)));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <M extends FloatMxN> M scale(@NotNull M toScale, float factor, @UniqueView @NotNull M store) {
        assert (VMath.matchingDimensions(toScale, store));
        for (int x = 0; x < toScale.getWidth(); ++x) {
            for (int y = 0; y < toScale.getHeight(); ++y) {
                store.put(y, x, toScale.get(y, x) * factor);
            }
        }
        return store;
    }

    public static float determinant(@NotNull Float4x4 mat) {
        return 0.0f + mat.get(0, 0) * mat.get(1, 1) * mat.get(2, 2) * mat.get(3, 3) + mat.get(0, 0) * mat.get(1, 2) * mat.get(2, 3) * mat.get(3, 1) + mat.get(0, 0) * mat.get(1, 3) * mat.get(2, 1) * mat.get(3, 2) - mat.get(0, 0) * mat.get(1, 3) * mat.get(2, 2) * mat.get(3, 1) - mat.get(0, 0) * mat.get(1, 2) * mat.get(2, 1) * mat.get(3, 3) - mat.get(0, 0) * mat.get(1, 1) * mat.get(2, 3) * mat.get(3, 2) - mat.get(0, 1) * mat.get(1, 0) * mat.get(2, 2) * mat.get(3, 3) - mat.get(0, 2) * mat.get(1, 0) * mat.get(2, 3) * mat.get(3, 1) - mat.get(0, 3) * mat.get(1, 0) * mat.get(2, 1) * mat.get(3, 2) + mat.get(0, 3) * mat.get(1, 0) * mat.get(2, 2) * mat.get(3, 1) + mat.get(0, 2) * mat.get(1, 0) * mat.get(2, 1) * mat.get(3, 3) + mat.get(0, 1) * mat.get(1, 0) * mat.get(2, 3) * mat.get(3, 2) + mat.get(0, 1) * mat.get(1, 2) * mat.get(2, 0) * mat.get(3, 3) + mat.get(0, 2) * mat.get(1, 3) * mat.get(2, 0) * mat.get(3, 1) + mat.get(0, 3) * mat.get(1, 1) * mat.get(2, 0) * mat.get(3, 2) - mat.get(0, 3) * mat.get(1, 2) * mat.get(2, 0) * mat.get(3, 1) - mat.get(0, 2) * mat.get(1, 1) * mat.get(2, 0) * mat.get(3, 3) - mat.get(0, 1) * mat.get(1, 3) * mat.get(2, 0) * mat.get(3, 2) - mat.get(0, 1) * mat.get(1, 2) * mat.get(2, 3) * mat.get(3, 0) - mat.get(0, 2) * mat.get(1, 3) * mat.get(2, 1) * mat.get(3, 0) - mat.get(0, 3) * mat.get(1, 1) * mat.get(2, 2) * mat.get(3, 0) + mat.get(0, 3) * mat.get(1, 2) * mat.get(2, 1) * mat.get(3, 0) + mat.get(0, 2) * mat.get(1, 1) * mat.get(2, 3) * mat.get(3, 0) + mat.get(0, 1) * mat.get(1, 3) * mat.get(2, 2) * mat.get(3, 0);
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static <M extends Float4x4> M adjugate(@NotNull M mat, @Unique @NotNull M store) {
        assert (VMath.uniqueMatrix(store, mat));
        store.put(0, 0, 0.0f + mat.get(1, 1) * mat.get(2, 2) * mat.get(3, 3) + mat.get(1, 2) * mat.get(2, 3) * mat.get(3, 1) + mat.get(1, 3) * mat.get(2, 1) * mat.get(3, 2) - mat.get(1, 3) * mat.get(2, 2) * mat.get(3, 1) - mat.get(1, 2) * mat.get(2, 1) * mat.get(3, 3) - mat.get(1, 1) * mat.get(2, 3) * mat.get(3, 2));
        store.put(1, 0, 0.0f - mat.get(1, 0) * mat.get(2, 2) * mat.get(3, 3) - mat.get(1, 2) * mat.get(2, 3) * mat.get(3, 0) - mat.get(1, 3) * mat.get(2, 0) * mat.get(3, 2) + mat.get(1, 3) * mat.get(2, 2) * mat.get(3, 0) + mat.get(1, 2) * mat.get(2, 0) * mat.get(3, 3) + mat.get(1, 0) * mat.get(2, 3) * mat.get(3, 2));
        store.put(2, 0, 0.0f + mat.get(1, 0) * mat.get(2, 1) * mat.get(3, 3) + mat.get(1, 1) * mat.get(2, 3) * mat.get(3, 0) + mat.get(1, 3) * mat.get(2, 0) * mat.get(3, 1) - mat.get(1, 3) * mat.get(2, 1) * mat.get(3, 0) - mat.get(1, 1) * mat.get(2, 0) * mat.get(3, 3) - mat.get(1, 0) * mat.get(2, 3) * mat.get(3, 1));
        store.put(3, 0, 0.0f - mat.get(1, 0) * mat.get(2, 1) * mat.get(3, 2) - mat.get(1, 1) * mat.get(2, 2) * mat.get(3, 0) - mat.get(1, 2) * mat.get(2, 0) * mat.get(3, 1) + mat.get(1, 2) * mat.get(2, 1) * mat.get(3, 0) + mat.get(1, 1) * mat.get(2, 0) * mat.get(3, 2) + mat.get(1, 0) * mat.get(2, 2) * mat.get(3, 1));
        store.put(0, 1, 0.0f - mat.get(0, 1) * mat.get(2, 2) * mat.get(3, 3) - mat.get(0, 2) * mat.get(2, 3) * mat.get(3, 1) - mat.get(0, 3) * mat.get(2, 1) * mat.get(3, 2) + mat.get(0, 3) * mat.get(2, 2) * mat.get(3, 1) + mat.get(0, 2) * mat.get(2, 1) * mat.get(3, 3) + mat.get(0, 1) * mat.get(2, 3) * mat.get(3, 2));
        store.put(1, 1, 0.0f + mat.get(0, 0) * mat.get(2, 2) * mat.get(3, 3) + mat.get(0, 2) * mat.get(2, 3) * mat.get(3, 0) + mat.get(0, 3) * mat.get(2, 0) * mat.get(3, 2) - mat.get(0, 3) * mat.get(2, 2) * mat.get(3, 0) - mat.get(0, 2) * mat.get(2, 0) * mat.get(3, 3) - mat.get(0, 0) * mat.get(2, 3) * mat.get(3, 2));
        store.put(2, 1, 0.0f - mat.get(0, 0) * mat.get(2, 1) * mat.get(3, 3) - mat.get(0, 1) * mat.get(2, 3) * mat.get(3, 0) - mat.get(0, 3) * mat.get(2, 0) * mat.get(3, 1) + mat.get(0, 3) * mat.get(2, 1) * mat.get(3, 0) + mat.get(0, 1) * mat.get(2, 0) * mat.get(3, 3) + mat.get(0, 0) * mat.get(2, 3) * mat.get(3, 1));
        store.put(3, 1, 0.0f + mat.get(0, 0) * mat.get(2, 1) * mat.get(3, 2) + mat.get(0, 1) * mat.get(2, 2) * mat.get(3, 0) + mat.get(0, 2) * mat.get(2, 0) * mat.get(3, 1) - mat.get(0, 2) * mat.get(2, 1) * mat.get(3, 0) - mat.get(0, 1) * mat.get(2, 0) * mat.get(3, 2) - mat.get(0, 0) * mat.get(2, 2) * mat.get(3, 1));
        store.put(0, 2, 0.0f + mat.get(0, 1) * mat.get(1, 2) * mat.get(3, 3) + mat.get(0, 2) * mat.get(1, 3) * mat.get(3, 1) + mat.get(0, 3) * mat.get(1, 1) * mat.get(3, 2) - mat.get(0, 3) * mat.get(1, 2) * mat.get(3, 1) - mat.get(0, 2) * mat.get(1, 1) * mat.get(3, 3) - mat.get(0, 1) * mat.get(1, 3) * mat.get(3, 2));
        store.put(1, 2, 0.0f - mat.get(0, 0) * mat.get(1, 2) * mat.get(3, 3) - mat.get(0, 2) * mat.get(1, 3) * mat.get(3, 0) - mat.get(0, 3) * mat.get(1, 0) * mat.get(3, 2) + mat.get(0, 3) * mat.get(1, 2) * mat.get(3, 0) + mat.get(0, 2) * mat.get(1, 0) * mat.get(3, 3) + mat.get(0, 0) * mat.get(1, 3) * mat.get(3, 2));
        store.put(2, 2, 0.0f + mat.get(0, 0) * mat.get(1, 1) * mat.get(3, 3) + mat.get(0, 1) * mat.get(1, 3) * mat.get(3, 0) + mat.get(0, 3) * mat.get(1, 0) * mat.get(3, 1) - mat.get(0, 3) * mat.get(1, 1) * mat.get(3, 0) - mat.get(0, 1) * mat.get(1, 0) * mat.get(3, 3) - mat.get(0, 0) * mat.get(1, 3) * mat.get(3, 1));
        store.put(3, 2, 0.0f - mat.get(0, 0) * mat.get(1, 1) * mat.get(3, 2) - mat.get(0, 1) * mat.get(1, 2) * mat.get(3, 0) - mat.get(0, 2) * mat.get(1, 0) * mat.get(3, 1) + mat.get(0, 2) * mat.get(1, 1) * mat.get(3, 0) + mat.get(0, 1) * mat.get(1, 0) * mat.get(3, 2) + mat.get(0, 0) * mat.get(1, 2) * mat.get(3, 1));
        store.put(0, 3, 0.0f - mat.get(0, 1) * mat.get(1, 2) * mat.get(2, 3) - mat.get(0, 2) * mat.get(1, 3) * mat.get(2, 1) - mat.get(0, 3) * mat.get(1, 1) * mat.get(2, 2) + mat.get(0, 3) * mat.get(1, 2) * mat.get(2, 1) + mat.get(0, 2) * mat.get(1, 1) * mat.get(2, 3) + mat.get(0, 1) * mat.get(1, 3) * mat.get(2, 2));
        store.put(1, 3, 0.0f + mat.get(0, 0) * mat.get(1, 2) * mat.get(2, 3) + mat.get(0, 2) * mat.get(1, 3) * mat.get(2, 0) + mat.get(0, 3) * mat.get(1, 0) * mat.get(2, 2) - mat.get(0, 3) * mat.get(1, 2) * mat.get(2, 0) - mat.get(0, 2) * mat.get(1, 0) * mat.get(2, 3) - mat.get(0, 0) * mat.get(1, 3) * mat.get(2, 2));
        store.put(2, 3, 0.0f - mat.get(0, 0) * mat.get(1, 1) * mat.get(2, 3) - mat.get(0, 1) * mat.get(1, 3) * mat.get(2, 0) - mat.get(0, 3) * mat.get(1, 0) * mat.get(2, 1) + mat.get(0, 3) * mat.get(1, 1) * mat.get(2, 0) + mat.get(0, 1) * mat.get(1, 0) * mat.get(2, 3) + mat.get(0, 0) * mat.get(1, 3) * mat.get(2, 1));
        store.put(3, 3, 0.0f + mat.get(0, 0) * mat.get(1, 1) * mat.get(2, 2) + mat.get(0, 1) * mat.get(1, 2) * mat.get(2, 0) + mat.get(0, 2) * mat.get(1, 0) * mat.get(2, 1) - mat.get(0, 2) * mat.get(1, 1) * mat.get(2, 0) - mat.get(0, 1) * mat.get(1, 0) * mat.get(2, 2) - mat.get(0, 0) * mat.get(1, 2) * mat.get(2, 1));
        return store;
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static <M extends Float4x4> M inverse(@NotNull M mat, @Unique @NotNull M store) {
        assert (VMath.uniqueMatrix(store, mat));
        return VMath.scale(VMath.adjugate(mat, store), 1.0f / VMath.determinant(mat), store);
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static <M extends MinFloat3x3> M transpose3x3(@NotNull M mat, @UniqueView @NotNull M store) {
        assert (VMath.uniqueViewVector(store, mat));
        if (store != mat) {
            store.put(0, 0, mat.get(0, 0));
            store.put(1, 1, mat.get(1, 1));
            store.put(2, 2, mat.get(2, 2));
        }
        VMath.swapWithBuf(mat, store, 0, 1, 1, 0);
        VMath.swapWithBuf(mat, store, 0, 2, 2, 0);
        VMath.swapWithBuf(mat, store, 1, 2, 2, 1);
        return store;
    }

    private static void swapWithBuf(@NotNull FloatMxN read, @NotNull FloatMxN store, int ya, int xa, int yb, int xb) {
        float buf = read.get(ya, xa);
        store.put(ya, xa, read.get(yb, xb));
        store.put(yb, xb, buf);
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <M extends MinFloat3x3> M rotationMatrix(float angle, @NotNull Float3 axis, @NotNull M store) {
        assert (Vector.isNormalized(axis, 1.0E-4f));
        store.put(0, 0, (float)((double)(axis.x() * axis.x()) * (1.0 - Math.cos(angle)) + Math.cos(angle)));
        store.put(0, 1, (float)((double)(axis.x() * axis.y()) * (1.0 - Math.cos(angle)) - (double)axis.z() * Math.sin(angle)));
        store.put(0, 2, (float)((double)(axis.x() * axis.z()) * (1.0 - Math.cos(angle)) + (double)axis.y() * Math.sin(angle)));
        store.put(1, 0, (float)((double)(axis.x() * axis.y()) * (1.0 - Math.cos(angle)) + (double)axis.z() * Math.sin(angle)));
        store.put(1, 1, (float)((double)(axis.y() * axis.y()) * (1.0 - Math.cos(angle)) + Math.cos(angle)));
        store.put(1, 2, (float)((double)(axis.y() * axis.z()) * (1.0 - Math.cos(angle)) - (double)axis.x() * Math.sin(angle)));
        store.put(2, 0, (float)((double)(axis.x() * axis.z()) * (1.0 - Math.cos(angle)) - (double)axis.y() * Math.sin(angle)));
        store.put(2, 1, (float)((double)(axis.y() * axis.z()) * (1.0 - Math.cos(angle)) + (double)axis.x() * Math.sin(angle)));
        store.put(2, 2, (float)((double)(axis.z() * axis.z()) * (1.0 - Math.cos(angle)) + Math.cos(angle)));
        return store;
    }

    @Contract(value="_, _, _, _ -> param4")
    @NotNull
    public static <M extends MinFloat3x3> M rotationMatrix(float yaw, float pitch, float roll, @NotNull M store) {
        store.put(0, 0, (float)(Math.cos(yaw) * Math.cos(pitch)));
        store.put(0, 1, (float)(Math.cos(yaw) * Math.sin(pitch) * Math.sin(roll) - Math.sin(yaw) * Math.cos(roll)));
        store.put(0, 2, (float)(Math.cos(yaw) * Math.sin(pitch) * Math.cos(roll) + Math.sin(yaw) * Math.sin(roll)));
        store.put(1, 0, (float)(Math.sin(yaw) * Math.cos(pitch)));
        store.put(1, 1, (float)(Math.sin(yaw) * Math.sin(pitch) * Math.sin(roll) + Math.cos(yaw) * Math.cos(roll)));
        store.put(1, 2, (float)(Math.sin(yaw) * Math.sin(pitch) * Math.cos(roll) - Math.cos(yaw) * Math.sin(roll)));
        store.put(2, 0, (float)(-Math.sin(pitch)));
        store.put(2, 1, (float)(Math.cos(pitch) * Math.sin(roll)));
        store.put(2, 2, (float)(Math.cos(pitch) * Math.cos(roll)));
        return store;
    }

    @NotNull
    public static <M extends Float4x4> M translationMatrix(@NotNull Float3 translation, @NotNull M store) {
        store.put(0, 3, translation.x());
        store.put(1, 3, translation.y());
        store.put(2, 3, translation.z());
        return store;
    }

    @NotNull
    public static <M extends FloatMxN> M diagonalMatrix(float value, boolean fillZeros, @NotNull M store) {
        int i;
        for (i = 0; i < store.getHeight() && i < store.getWidth(); ++i) {
            store.put(i, i, value);
        }
        if (fillZeros) {
            for (i = 0; i < store.getHeight(); ++i) {
                for (int j = 0; j < store.getWidth(); ++j) {
                    if (i == j) continue;
                    store.put(i, j, 0.0f);
                }
            }
        }
        return store;
    }

    static Float4x4 projectionMatrixExplained(float aspect, float width, float height, float near, float far, boolean perspective, float fudgeFactor) {
        ABFloat4x4 mat = new ABFloat4x4();
        mat.put(0, 0, 2.0f / (aspect * width));
        mat.put(1, 1, 2.0f / height);
        mat.put(2, 2, 1.0f / (far - near));
        mat.put(2, 3, -near / (far - near));
        if (perspective) {
            mat.put(3, 2, fudgeFactor / (far - near));
            mat.put(3, 3, -fudgeFactor * near / (far - near) + 1.0f);
        } else {
            mat.put(3, 3, 1.0f);
        }
        return mat;
    }

    public static <M extends MinFloat4x4> M projectionMatrix(float aspect, float width, float height, float near, float far, boolean invertY, boolean perspective, float fudgeFactor, @NotNull M store) {
        float dfn = 1.0f / (far - near);
        float nDfn = -near * dfn;
        store.put(0, 0, 2.0f / (aspect * width));
        if (invertY) {
            store.put(1, 1, -2.0f / height);
        } else {
            store.put(1, 1, 2.0f / height);
        }
        store.put(2, 2, dfn);
        store.put(2, 3, nDfn);
        if (perspective) {
            store.put(3, 2, fudgeFactor * dfn);
            store.put(3, 3, fudgeFactor * nDfn + 1.0f);
        } else {
            store.put(3, 3, 1.0f);
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static Float4 multiply(@NotNull Float4x4 left, @NotNull Float4 right, @NotNull Float4 store) {
        float storeX = 0.0f + right.get(0) * left.get(0, 0) + right.get(1) * left.get(0, 1) + right.get(2) * left.get(0, 2) + right.get(3) * left.get(0, 3);
        float storeY = 0.0f + right.get(0) * left.get(1, 0) + right.get(1) * left.get(1, 1) + right.get(2) * left.get(1, 2) + right.get(3) * left.get(1, 3);
        float storeZ = 0.0f + right.get(0) * left.get(2, 0) + right.get(1) * left.get(2, 1) + right.get(2) * left.get(2, 2) + right.get(3) * left.get(2, 3);
        float storeW = 0.0f + right.get(0) * left.get(3, 0) + right.get(1) * left.get(3, 1) + right.get(2) * left.get(3, 2) + right.get(3) * left.get(3, 3);
        store.xyzw(storeX, storeY, storeZ, storeW);
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static Float3 multiply(@NotNull Float3x3 left, @NotNull Float3 right, @NotNull Float3 store) {
        float storeX = 0.0f + right.get(0) * left.get(0, 0) + right.get(1) * left.get(0, 1) + right.get(2) * left.get(0, 2);
        float storeY = 0.0f + right.get(0) * left.get(1, 0) + right.get(1) * left.get(1, 1) + right.get(2) * left.get(1, 2);
        float storeZ = 0.0f + right.get(0) * left.get(2, 0) + right.get(1) * left.get(2, 1) + right.get(2) * left.get(2, 2);
        store.xyz(storeX, storeY, storeZ);
        return store;
    }

    private static boolean matchingDimensions(Vector ... vectors) {
        int dim = vectors[0].getMemberCount();
        for (int i = 1; i < vectors.length; ++i) {
            if (vectors[i].getMemberCount() == dim) continue;
            return false;
        }
        return true;
    }

    private static boolean matchingDimensions(Matrix ... matrices) {
        int width = matrices[0].getWidth();
        int height = matrices[0].getHeight();
        for (int i = 1; i < matrices.length; ++i) {
            if (matrices[i].getWidth() == width && matrices[i].getHeight() == height) continue;
            return false;
        }
        return true;
    }

    private static boolean uniqueVector(@NotNull Vector unique, Vector ... vectors) {
        Vector original = unique.isView() ? unique.getAsView().getOriginal() : unique;
        for (int i = 0; i < vectors.length; ++i) {
            if (original != (vectors[i].isView() ? vectors[i].getAsView().getOriginal() : vectors[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean uniqueViewVector(@NotNull Vector unique, Vector ... vectors) {
        if (unique.isView()) {
            Object original = unique.getAsView().getOriginal();
            boolean isUniqueMappingSpecial = Vector.View.isMappingSpecial(unique);
            int[] defaultMapping = unique.getAsView().getMapping();
            for (int i = 0; i < vectors.length; ++i) {
                if (vectors[i].isView() && original == vectors[i].getAsView().getOriginal() && Vector.View.isMappingSpecial(defaultMapping, vectors[i]) && Vector.View.doesMappingCollide(defaultMapping, vectors[i].getAsView().getMapping())) {
                    return false;
                }
                if (vectors[i].isView() || vectors[i] != original || !isUniqueMappingSpecial) continue;
                return false;
            }
        } else {
            for (int i = 0; i < vectors.length; ++i) {
                if (!vectors[i].isView() || unique != vectors[i].getAsView().getOriginal() || !Vector.View.isMappingSpecial(vectors[i])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean uniqueMatrix(@NotNull Matrix unique, Matrix ... matrices) {
        for (int i = 0; i < matrices.length; ++i) {
            if (unique != matrices[i]) continue;
            return false;
        }
        return true;
    }

    private VMath() {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface UniqueView {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Unique {
    }
}

