/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.llist;

import de.linusdev.lutils.llist.LLinkedListEntry;
import de.linusdev.lutils.llist.LLinkedListIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLinkedList<O>
implements List<O> {
    @NotNull
    final Object lock = new Object();
    volatile int size;
    @NotNull
    private final LLinkedListEntry<O> head = new LLinkedListEntry<Object>(null);
    @NotNull
    private LLinkedListEntry<O> tail = this.head;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R doSynchronized(@NotNull Function<LLinkedList<O>, R> function) {
        Object object = this.lock;
        synchronized (object) {
            return function.apply(this);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head.getNext() == null;
    }

    @Override
    public boolean contains(Object o) {
        for (Object value : this) {
            if (!Objects.equals(value, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public LLinkedListIterator<O> iterator() {
        return new LLinkedListIterator(this);
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        Object[] array = new Object[this.size];
        int i = 0;
        for (Object value : this) {
            array[i++] = value;
        }
        return array;
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(T @NotNull [] a) {
        return Arrays.copyOf(this.toArray(), this.size, a.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(O o) {
        Object object = this.lock;
        synchronized (object) {
            LLinkedListEntry<O> entry = new LLinkedListEntry<O>(o);
            this.tail.setNext(entry);
            this.tail = entry;
            ++this.size;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.iterator();
            while (((LLinkedListIterator)this.iterator()).hasNext()) {
                if (!Objects.equals(((LLinkedListIterator)iterator).next(), o)) continue;
                this.remove(((LLinkedListIterator)iterator).getLastEntry(), ((LLinkedListIterator)iterator).getCurrentEntry());
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(@NotNull LLinkedListEntry<O> beforeEntry, @NotNull LLinkedListEntry<O> removeEntry) {
        Object object = this.lock;
        synchronized (object) {
            if (removeEntry == this.tail) {
                this.tail = beforeEntry;
                beforeEntry.setNext(null);
            } else {
                beforeEntry.setNext(removeEntry.getNext());
            }
            --this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(@NotNull LLinkedListEntry<O> entry) {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.iterator();
            while (((LLinkedListIterator)iterator).hasNext()) {
                ((LLinkedListIterator)iterator).next();
                if (((LLinkedListIterator)iterator).getCurrentEntry() != entry) continue;
                this.remove(((LLinkedListIterator)iterator).getLastEntry(), ((LLinkedListIterator)iterator).getCurrentEntry());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(@NotNull LLinkedListEntry<O> beforeEntry, @NotNull LLinkedListEntry<O> toAddEntry) {
        Object object = this.lock;
        synchronized (object) {
            if (beforeEntry == this.tail) {
                this.tail.setNext(toAddEntry);
                this.tail = toAddEntry;
                ++this.size;
                return;
            }
            LLinkedListEntry<O> toMove = beforeEntry.getNext();
            beforeEntry.setNext(toAddEntry);
            toAddEntry.setNext(toMove);
        }
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(@NotNull Collection<? extends O> c) {
        Object object = this.lock;
        synchronized (object) {
            for (O o : c) {
                this.add(o);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, @NotNull Collection<? extends O> c) {
        Object object = this.lock;
        synchronized (object) {
            if (index == this.size) {
                return this.addAll((Collection<? extends O>)c);
            }
            if (c.isEmpty()) {
                return false;
            }
            LLinkedListEntry<O> before = this.getEntry(index - 1);
            LLinkedListEntry<O> toMove = before.getNext();
            LLinkedListEntry<O> lastAdded = null;
            for (O o : c) {
                lastAdded = new LLinkedListEntry<O>(o);
                before.setNext(lastAdded);
                before = lastAdded;
                ++this.size;
            }
            lastAdded.setNext(toMove);
            return true;
        }
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void clear() {
        this.head.setNext(null);
    }

    @Override
    public O get(int index) {
        int i = 0;
        for (Object value : this) {
            if (i++ != index) continue;
            return (O)value;
        }
        throw new IndexOutOfBoundsException(index);
    }

    @NotNull
    private LLinkedListEntry<O> getEntry(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(index);
        }
        Iterator it = this.iterator();
        for (int i = 0; i <= index; ++i) {
            ((LLinkedListIterator)it).next();
        }
        return ((LLinkedListIterator)it).getCurrentEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public O set(int index, @Nullable O element) {
        Object object = this.lock;
        synchronized (object) {
            LLinkedListEntry<O> entry = this.getEntry(index);
            O old = entry.getValue();
            entry.setValue(element);
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, O element) {
        Object object = this.lock;
        synchronized (object) {
            if (index == this.size) {
                this.add(element);
                return;
            }
            LLinkedListEntry<O> before = this.getEntry(index - 1);
            LLinkedListEntry<O> toMove = before.getNext();
            LLinkedListEntry<O> toAdd = new LLinkedListEntry<O>(element);
            before.setNext(toAdd);
            toAdd.setNext(toMove);
            ++this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public O remove(int index) {
        Object object = this.lock;
        synchronized (object) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException(index);
            }
            LLinkedListEntry<O> before = this.getEntry(index - 1);
            O removed = before.getNext().getValue();
            this.remove(before, before.getNext());
            return removed;
        }
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @NotNull
    public ListIterator<O> listIterator() {
        return new LLinkedListIterator(this);
    }

    @Override
    @NotNull
    public ListIterator<O> listIterator(int index) {
        if (index == 0) {
            return this.listIterator();
        }
        LLinkedListEntry<O> before = this.getEntry(index - 1);
        LLinkedListEntry<O> next = before.getNext();
        if (next == null) {
            throw new IndexOutOfBoundsException(index);
        }
        return new LLinkedListIterator<O>(this, index, before, next);
    }

    @Override
    @NotNull
    public List<O> subList(int fromIndex, int toIndex) {
        LLinkedList sub = new LLinkedList();
        int index = 0;
        for (Object o : this) {
            if (index >= toIndex) {
                return sub;
            }
            if (index < fromIndex) continue;
            sub.add((O)o);
        }
        return sub;
    }

    @NotNull
    LLinkedListEntry<O> getHead() {
        return this.head;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (Object value : this) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(value);
        }
        sb.append("]");
        return sb.toString();
    }
}

