/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.java;

import de.linusdev.lutils.image.Image;
import de.linusdev.lutils.image.PixelFormat;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBackedImage
implements Image {
    @NotNull
    private final BufferedImage image;

    public JavaBackedImage(@NotNull BufferedImage image) {
        this.image = image;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getPixelAsRGBA(int x, int y) {
        return PixelFormat.A8R8G8B8_SRGB.toR8G8B8A8_SRGB(this.image.getRGB(x, y));
    }

    @Override
    public void setPixelAsRGBA(int x, int y, int rgba) {
        this.image.setRGB(x, y, PixelFormat.R8G8B8A8_SRGB.toA8R8G8B8_SRGB(rgba));
    }

    @Override
    public boolean isReadOnly() {
        return !this.image.hasTileWriters();
    }

    public void write(@Nullable String formatName, @NotNull OutputStream stream) throws IOException {
        if (formatName == null) {
            formatName = "png";
        }
        ImageIO.write((RenderedImage)this.image, formatName, stream);
    }
}

