/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.buffer;

import de.linusdev.lutils.image.Image;
import de.linusdev.lutils.image.ImageSize;
import de.linusdev.lutils.image.PixelFormat;
import de.linusdev.lutils.image.buffer.BBImageInfo;
import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.RequirementType;
import de.linusdev.lutils.nat.struct.annos.SVWrapper;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.annos.StructureSettings;
import de.linusdev.lutils.nat.struct.generator.StaticGenerator;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.utils.SSMUtils;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, customLengthOption=RequirementType.REQUIRED)
public class BBInt32Image
extends Structure
implements Image {
    @NotNull
    public static final StaticGenerator GENERATOR = new StaticGenerator(){

        @Override
        @NotNull
        public StructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable StructValue structValue, @NotNull @NotNull StructValue @NotNull [] elementsStructValue, @NotNull ABI abi, @NotNull OverwriteChildABI overwriteChildAbi) {
            assert (structValue != null);
            int width = structValue.length()[0];
            int height = structValue.length()[1];
            return new BBImageInfo(4, false, width, height, 4, 0, 0);
        }
    };
    private int width = 0;
    private int height = 0;
    private int pixelSize = 0;
    @NotNull
    private final PixelFormat<Integer> pixelFormat;

    @NotNull
    public static BBInt32Image newUnallocated(@NotNull PixelFormat<Integer> pixelFormat) {
        return new BBInt32Image(null, false, pixelFormat);
    }

    @NotNull
    public static BBInt32Image newAllocatable(@NotNull StructValue structValue, @NotNull PixelFormat<Integer> pixelFormat) {
        return new BBInt32Image(structValue, true, pixelFormat);
    }

    @NotNull
    public static BBInt32Image newAllocatable(@NotNull ImageSize size, @NotNull PixelFormat<Integer> pixelFormat) {
        return new BBInt32Image(SVWrapper.imageSize(size), true, pixelFormat);
    }

    @NotNull
    public static BBInt32Image newAllocated(@NotNull StructValue structValue, @NotNull PixelFormat<Integer> pixelFormat) {
        return BBInt32Image.allocate(new BBInt32Image(structValue, true, pixelFormat));
    }

    protected BBInt32Image(@Nullable StructValue structValue, boolean generateInfo, @NotNull PixelFormat<Integer> pixelFormat) {
        this.pixelFormat = pixelFormat;
        assert (!generateInfo || structValue != null);
        if (generateInfo) {
            this.setInfo(SSMUtils.getInfo(this.getClass(), structValue, null, null, null, null, GENERATOR));
        }
    }

    @Override
    protected void useBuffer(@NotNull Structure mostParentStructure, int offset, @NotNull StructureInfo info) {
        super.useBuffer(mostParentStructure, offset, info);
        this.byteBuf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    @NotNull
    public BBImageInfo getInfo() {
        return (BBImageInfo)super.getInfo();
    }

    @Override
    protected void onSetInfo(@NotNull StructureInfo info) {
        super.onSetInfo(info);
        this.width = this.getInfo().getWidth();
        this.height = this.getInfo().getHeight();
        this.pixelSize = this.getInfo().getPixelSize();
    }

    @Override
    public int getWidth() {
        return this.getInfo().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getInfo().getHeight();
    }

    @Override
    public int getPixelAsRGBA(int x, int y) {
        assert (x < this.width);
        assert (y < this.height);
        return this.pixelFormat.toR8G8B8A8_SRGB(this.fixEndianness(this.byteBuf.getInt((y * this.width + x) * this.pixelSize)));
    }

    public int fixEndianness(int rgba) {
        return Integer.reverseBytes(rgba);
    }

    @Override
    public void setPixelAsRGBA(int x, int y, int rgba) {
        assert (x < this.width);
        assert (y < this.height);
        this.byteBuf.putInt((y * this.getWidth() + x) * this.pixelSize, this.fixEndianness(this.pixelFormat.from(PixelFormat.R8G8B8A8_SRGB, rgba)));
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

