/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.atlas;

import de.linusdev.lutils.image.Image;
import de.linusdev.lutils.image.ImageSize;
import de.linusdev.lutils.image.atlas.Atlas;
import de.linusdev.lutils.image.atlas.AtlasImage;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ImageRef<ID>
implements ImageSize {
    private final ID id;
    private boolean rotate = false;
    @NotNull
    private final ImageSize size;
    @NotNull
    private final Store store;

    public ImageRef(ID id, @NotNull ImageSize size, @NotNull Store store) {
        this.id = id;
        this.size = size;
        this.store = store;
    }

    @NotNull
    static <ID> ImageRef<ID> ofImage(final @NotNull Image src, ID id) {
        return new ImageRef<ID>(id, src, new Store(){

            @Override
            public void storeTo(@NotNull Image image, int offsetX, int offsetY) {
                Image.copy(src, 0, 0, image, offsetX, offsetY);
            }

            @Override
            public void storeRotatedTo(@NotNull Image image, int offsetX, int offsetY) {
                Image.copy(src.createRotatedView(), 0, 0, image, offsetX, offsetY);
            }
        });
    }

    void storeTo(@NotNull Atlas<?, ID> atlas, int offsetX, int offsetY) throws IOException {
        if (this.rotate) {
            this.store.storeRotatedTo(atlas, offsetX, offsetY);
        } else {
            this.store.storeTo(atlas, offsetX, offsetY);
        }
        atlas.addImage(this, offsetX, offsetY);
    }

    protected void onAddedToAtlas(@NotNull AtlasImage<ID> added) {
    }

    void rotate() {
        this.rotate = !this.rotate;
    }

    boolean isRotated() {
        return this.rotate;
    }

    public ID getId() {
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.rotate ? this.size.getHeight() : this.size.getWidth();
    }

    @Override
    public int getHeight() {
        return this.rotate ? this.size.getWidth() : this.size.getHeight();
    }

    public static interface Store {
        public void storeTo(@NotNull Image var1, int var2, int var3) throws IOException;

        public void storeRotatedTo(@NotNull Image var1, int var2, int var3) throws IOException;
    }
}

