/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.parser;

import de.linusdev.lutils.html.HtmlAttribute;
import de.linusdev.lutils.html.HtmlAttributeMap;
import de.linusdev.lutils.html.HtmlAttributeType;
import de.linusdev.lutils.html.HtmlElementType;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.impl.StandardHtmlAttribute;
import de.linusdev.lutils.html.parser.HtmlParser;
import de.linusdev.lutils.html.parser.HtmlParserInjector;
import de.linusdev.lutils.html.parser.ParseException;
import de.linusdev.lutils.html.parser.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlParserState
implements HtmlParserInjector {
    @Nullable
    private final HtmlParserInjector injector;
    @NotNull
    private final HtmlParser parser;

    public HtmlParserState(@Nullable HtmlParserInjector injector, @NotNull HtmlParser parser) {
        this.injector = injector;
        this.parser = parser;
    }

    @NotNull
    public HtmlParser getParser() {
        return this.parser;
    }

    @NotNull
    public Registry getRegistry() {
        return this.parser.getRegistry();
    }

    @NotNull
    public ParseException fail(@NotNull String message) {
        return new ParseException(message);
    }

    @NotNull
    public ParseException fail(char c) {
        return new ParseException(c);
    }

    @Override
    @Nullable
    public HtmlAttribute onAttributeParsed(@NotNull HtmlAttributeType<?> type, @Nullable String value) {
        if (this.injector == null) {
            return new StandardHtmlAttribute(type, value);
        }
        return this.injector.onAttributeParsed(type, value);
    }

    @Override
    public int onStartParsingContent(@NotNull HtmlElementType<?> tag, @NotNull HtmlAttributeMap attributes) {
        if (this.injector == null) {
            return 0;
        }
        return this.injector.onStartParsingContent(tag, attributes);
    }

    @Override
    @Nullable
    public HtmlObject onObjectParsed(@NotNull HtmlObject parsed) {
        if (this.injector == null) {
            return parsed;
        }
        return this.injector.onObjectParsed(parsed);
    }

    @Override
    public void onEndParsingContent(int id) {
        if (this.injector == null) {
            return;
        }
        this.injector.onEndParsingContent(id);
    }
}

