/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.lhtml;

import de.linusdev.lutils.html.EditableHtmlElement;
import de.linusdev.lutils.html.HtmlAddable;
import de.linusdev.lutils.html.HtmlAttributeMap;
import de.linusdev.lutils.html.HtmlElementType;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectType;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholder;
import de.linusdev.lutils.html.lhtml.LhtmlTemplate;
import de.linusdev.lutils.html.lhtml.skeleton.LhtmlTemplateSkeleton;
import de.linusdev.lutils.html.parser.HtmlWritingState;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LhtmlTemplateElement
implements EditableHtmlElement,
LhtmlTemplate {
    @NotNull
    protected final String id;
    @NotNull
    protected final Map<String, LhtmlPlaceholder> placeholders;
    @NotNull
    protected final Map<String, LhtmlTemplateSkeleton> templates;
    @NotNull
    protected final Map<String, String> replaceValues;
    @NotNull
    protected final EditableHtmlElement actual;

    public LhtmlTemplateElement(@NotNull String id, @NotNull EditableHtmlElement actual, @NotNull Map<String, LhtmlPlaceholder> placeholders, @NotNull Map<String, LhtmlTemplateSkeleton> templates, @NotNull Map<String, String> replaceValues) {
        this.id = id;
        this.placeholders = placeholders;
        this.actual = actual;
        this.templates = templates;
        this.replaceValues = replaceValues;
    }

    @Override
    @NotNull
    public HtmlElementType<?> tag() {
        return this.actual.tag();
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull HtmlObject> content() {
        return this.actual.content();
    }

    @Override
    @NotNull
    public HtmlAttributeMap attributes() {
        return this.actual.attributes();
    }

    @Override
    @NotNull
    public HtmlObjectType type() {
        return HtmlObjectType.ELEMENT;
    }

    @Override
    @NotNull
    public LhtmlTemplateElement copy() {
        return LhtmlTemplateSkeleton.createCopy(this.id, this.actual, this.templates);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public HtmlAddable getPlaceholder(@NotNull String id) {
        return Objects.requireNonNull(this.placeholders.get(id), "No template found with id '" + id + "'.");
    }

    @Override
    @NotNull
    public LhtmlTemplateElement getTemplate(@NotNull String id) {
        return Objects.requireNonNull(this.templates.get(id)).copy();
    }

    @Override
    public void setValue(@NotNull String key, @NotNull String value) {
        this.replaceValues.put(key, value);
    }

    @Override
    public void write(@NotNull HtmlWritingState state, @NotNull Writer writer) throws IOException {
        this.actual.write(state, writer);
    }
}

