/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.lhtml;

import de.linusdev.lutils.html.EditableHtmlElement;
import de.linusdev.lutils.html.HtmlAttribute;
import de.linusdev.lutils.html.HtmlAttributeMap;
import de.linusdev.lutils.html.HtmlAttributeType;
import de.linusdev.lutils.html.HtmlElement;
import de.linusdev.lutils.html.HtmlElementType;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectType;
import de.linusdev.lutils.html.impl.StandardHtmlAttribute;
import de.linusdev.lutils.html.impl.element.StandardHtmlElementTypes;
import de.linusdev.lutils.html.lhtml.Lhtml;
import de.linusdev.lutils.html.lhtml.LhtmlHead;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholderAttribute;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholderElement;
import de.linusdev.lutils.html.lhtml.skeleton.LhtmlSkeletonBuilder;
import de.linusdev.lutils.html.parser.HtmlParserInjector;
import de.linusdev.lutils.other.str.ConstructableString;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LhtmlInjector
implements HtmlParserInjector {
    private final Stack<LhtmlSkeletonBuilder> builders = new Stack();

    @Nullable
    protected static ConstructableString getConstructableStringOfValue(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\$\\{(?<key>[a-zA-Z0-9-_]+)}");
        Matcher matcher = pattern.matcher(text);
        if (!matcher.find()) {
            return null;
        }
        ConstructableString.Builder builder = new ConstructableString.Builder();
        int start = 0;
        do {
            String constant;
            if (!(constant = text.substring(start, matcher.start())).isEmpty()) {
                builder.addConstant(constant);
            }
            builder.addPlaceholder(matcher.group("key"));
            start = matcher.end();
        } while (matcher.find());
        if (start != text.length()) {
            builder.addConstant(text.substring(start));
        }
        return builder.build();
    }

    public LhtmlInjector() {
        this.builders.add(new LhtmlSkeletonBuilder());
    }

    @Override
    @Nullable
    public HtmlAttribute onAttributeParsed(@NotNull HtmlAttributeType<?> type, @Nullable String value) {
        ConstructableString str = LhtmlInjector.getConstructableStringOfValue(value);
        if (str == null) {
            return new StandardHtmlAttribute(type, value);
        }
        return new LhtmlPlaceholderAttribute(type, str);
    }

    @Override
    public int onStartParsingContent(@NotNull HtmlElementType<?> tag, @NotNull HtmlAttributeMap attributes) {
        HtmlAttribute lhtmlTemplateAttr = attributes.get(Lhtml.ATTR_TEMPLATE);
        if (lhtmlTemplateAttr != null) {
            this.builders.push(new LhtmlSkeletonBuilder());
        }
        return 0;
    }

    @Override
    @Nullable
    public HtmlObject onObjectParsed(@NotNull HtmlObject parsed) {
        String placeholderId;
        if (parsed.type() != HtmlObjectType.ELEMENT) {
            return parsed;
        }
        HtmlElement element = parsed.asHtmlElement();
        if (element.tag() == LhtmlHead.TYPE) {
            this.builders.peek().setHead((LhtmlHead)element);
            return element;
        }
        if (HtmlElementType.equals(StandardHtmlElementTypes.BODY, element.tag())) {
            this.builders.peek().setBody(element);
        }
        if ((placeholderId = element.attributes().getValue(Lhtml.ATTR_PLACEHOLDER)) != null) {
            if (!(element instanceof EditableHtmlElement)) {
                throw new IllegalStateException("Parsed element is not editable!");
            }
            EditableHtmlElement editable = (EditableHtmlElement)element;
            LhtmlPlaceholderElement placeholder = new LhtmlPlaceholderElement(placeholderId, editable);
            LhtmlSkeletonBuilder builder = this.builders.peek();
            builder.addPlaceholder(placeholder);
            return placeholder;
        }
        String templateId = element.attributes().getValue(Lhtml.ATTR_TEMPLATE);
        if (templateId != null) {
            if (!(element instanceof EditableHtmlElement)) {
                throw new IllegalStateException("Parsed element is not editable!");
            }
            EditableHtmlElement editable = (EditableHtmlElement)element;
            LhtmlSkeletonBuilder builder = this.builders.pop();
            this.builders.peek().addTemplate(builder.buildTemplate(templateId, editable));
            return null;
        }
        return parsed;
    }

    @Override
    public void onEndParsingContent(int id) {
    }

    public LhtmlSkeletonBuilder getBuilder() {
        LhtmlSkeletonBuilder builder = this.builders.pop();
        assert (this.builders.isEmpty());
        return builder;
    }
}

