/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import de.linusdev.lutils.codegen.GeneratorState;
import de.linusdev.lutils.codegen.PartGenerator;
import de.linusdev.lutils.codegen.java.JavaAnnotateable;
import de.linusdev.lutils.codegen.java.JavaAnnotation;
import de.linusdev.lutils.codegen.java.JavaBlockContents;
import de.linusdev.lutils.codegen.java.JavaBlockContentsConsumer;
import de.linusdev.lutils.codegen.java.JavaClass;
import de.linusdev.lutils.codegen.java.JavaDocGenerator;
import de.linusdev.lutils.codegen.java.JavaDocable;
import de.linusdev.lutils.codegen.java.JavaFileState;
import de.linusdev.lutils.codegen.java.JavaLocalVariable;
import de.linusdev.lutils.codegen.java.JavaMethod;
import de.linusdev.lutils.codegen.java.JavaSourceGeneratorHelper;
import de.linusdev.lutils.codegen.java.JavaVisibility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodGenerator
implements JavaAnnotateable,
PartGenerator<JavaSourceGeneratorHelper>,
JavaDocable,
JavaMethod {
    @NotNull
    protected final JavaFileState ft;
    @NotNull
    protected final JavaClass parentClass;
    @NotNull
    protected final JavaClass returnType;
    @NotNull
    protected final String name;
    protected boolean isStatic = false;
    protected boolean isNative = false;
    protected boolean noBody = false;
    protected boolean isFinal = false;
    protected boolean isConstructor = false;
    @NotNull
    protected JavaVisibility visibility = JavaVisibility.PACKAGE_PRIVATE;
    @Nullable
    protected JavaDocGenerator javaDoc = null;
    @NotNull
    protected final List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
    @NotNull
    protected final List<JavaLocalVariable> parameters = new ArrayList<JavaLocalVariable>();
    @NotNull
    protected final JavaBlockContents body;

    public JavaMethodGenerator(@NotNull JavaFileState ft, @NotNull JavaClass parentClass, @NotNull JavaClass returnType, @NotNull String name) {
        this.ft = ft;
        this.parentClass = parentClass;
        this.returnType = returnType;
        this.name = name;
        this.body = new JavaBlockContents(ft);
        ft.addImport(returnType.getRequiredImports());
    }

    public void setVisibility(@NotNull JavaVisibility visibility) {
        this.visibility = visibility;
    }

    @NotNull
    public JavaVisibility getVisibility() {
        return this.visibility;
    }

    public void setStatic(boolean jStatic) {
        this.isStatic = jStatic;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public void setFinal(boolean jFinal) {
        this.isFinal = jFinal;
    }

    public void setNative(boolean aNative) {
        this.isNative = aNative;
        this.setNoBody(true);
    }

    public void setNoBody(boolean noBody) {
        this.noBody = noBody;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isNoBody() {
        return this.noBody;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setConstructor(boolean constructor) {
        this.isConstructor = constructor;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public JavaClass getParentClass() {
        return this.parentClass;
    }

    @Override
    @NotNull
    public JavaClass getReturnType() {
        return this.returnType;
    }

    @NotNull
    public <T> JavaLocalVariable addParameter(@NotNull String name, @NotNull JavaClass type) {
        JavaLocalVariable variable = new JavaLocalVariable(this.ft, type, name);
        this.ft.addImport(type.getRequiredImports());
        this.parameters.add(variable);
        return variable;
    }

    @NotNull
    public List<JavaLocalVariable> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public JavaAnnotation addAnnotation(@NotNull JavaClass annotationClass) {
        JavaAnnotation annotation = new JavaAnnotation(this.ft, annotationClass);
        this.annotations.add(annotation);
        return annotation;
    }

    public void body(@NotNull JavaBlockContentsConsumer consumer) {
        consumer.accept(this.body);
    }

    @Override
    public void write(@NotNull Appendable writer, @NotNull GeneratorState<JavaSourceGeneratorHelper> state) throws IOException {
        if (this.javaDoc != null) {
            this.javaDoc.write(writer, state);
        }
        for (JavaAnnotation annotation : this.annotations) {
            writer.append(state.getIndent()).append(state.getSg().javaAnnotation(annotation)).append(state.getSg().javaLineBreak());
        }
        writer.append(state.getIndent()).append(state.getSg().javaMethodOpenExpression(this));
        if (!this.isNoBody()) {
            writer.append(state.getSg().javaLineBreak());
            this.body.write(writer, state);
            writer.append(state.getSg().javaLineBreak()).append(state.getIndent());
        }
        writer.append(state.getSg().javaMethodCloseExpression(this));
    }

    @Override
    @NotNull
    public JavaDocGenerator setJavaDoc() {
        if (this.javaDoc == null) {
            this.javaDoc = new JavaDocGenerator();
        }
        return this.javaDoc;
    }
}

