/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import de.linusdev.lutils.codegen.GeneratorState;
import de.linusdev.lutils.codegen.PartGenerator;
import de.linusdev.lutils.codegen.java.JavaAssignable;
import de.linusdev.lutils.codegen.java.JavaClass;
import de.linusdev.lutils.codegen.java.JavaImport;
import de.linusdev.lutils.codegen.java.JavaLocalVariable;
import de.linusdev.lutils.codegen.java.JavaMethod;
import de.linusdev.lutils.codegen.java.JavaSourceGeneratorHelper;
import de.linusdev.lutils.codegen.java.JavaVariable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JavaExpression
extends PartGenerator<JavaSourceGeneratorHelper> {
    @NotNull
    public static JavaExpression ofCode(final @NotNull String code, final JavaImport ... requiredImports) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return code;
            }

            @Override
            @Nullable
            public Collection<JavaImport> getRequiredImports() {
                return requiredImports == null ? null : Arrays.asList(requiredImports);
            }
        };
    }

    @NotNull
    public static JavaExpression javaAssert(final @NotNull JavaExpression expression) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return "assert " + expression.getExprString(sg);
            }

            @Override
            @Nullable
            public Collection<JavaImport> getRequiredImports() {
                return expression.getRequiredImports();
            }
        };
    }

    @NotNull
    public static JavaExpression ofString(final @NotNull String string) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return "\"" + string.replace("\"", "\\\"") + "\"";
            }

            @Override
            @Nullable
            public Collection<JavaImport> getRequiredImports() {
                return null;
            }
        };
    }

    @NotNull
    public static JavaExpression assign(final @NotNull JavaAssignable variable, final @NotNull JavaExpression expression) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return variable.getName() + " " + sg.javaAssign() + " " + expression.getExprString(sg);
            }

            @Override
            @Nullable
            public Collection<JavaImport> getRequiredImports() {
                return expression.getRequiredImports();
            }
        };
    }

    @NotNull
    public static JavaExpression declare(final @NotNull JavaLocalVariable variable) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return sg.javaDeclareLocalVariableExpression(variable);
            }

            @Override
            @NotNull
            public Collection<JavaImport> getRequiredImports() {
                int s = 0;
                if (variable.getDefaultValue() != null && variable.getDefaultValue().getRequiredImports() != null) {
                    s += variable.getDefaultValue().getRequiredImports().size();
                }
                ArrayList<JavaImport> imports = new ArrayList<JavaImport>(s + 1);
                if (variable.getType().getRequiredImports() != null) {
                    imports.addAll(variable.getType().getRequiredImports());
                }
                if (s != 0) {
                    imports.addAll(variable.getDefaultValue().getRequiredImports());
                }
                return imports;
            }
        };
    }

    @NotNull
    public static JavaExpression nullExpression() {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return sg.javaNull();
            }
        };
    }

    @NotNull
    public static JavaExpression numberPrimitive(final @NotNull Number number) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return sg.javaNumberExpression(number);
            }
        };
    }

    @NotNull
    public static JavaExpression booleanPrimitive(final boolean bool) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return sg.javaBooleanExpression(bool);
            }
        };
    }

    @NotNull
    public static JavaExpression callSuper(final JavaExpression ... parameters) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return sg.javaMethodCall(sg.javaSuper(), parameters);
            }

            @Override
            @NotNull
            public Collection<JavaImport> getRequiredImports() {
                ArrayList<JavaImport> imports = new ArrayList<JavaImport>();
                for (JavaExpression parameter : parameters) {
                    if (parameter.getRequiredImports() == null) continue;
                    imports.addAll(parameter.getRequiredImports());
                }
                return imports;
            }
        };
    }

    @NotNull
    public static JavaExpression returnExpr(final @NotNull JavaExpression toReturn) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return "return " + toReturn.getExprString(sg);
            }

            @Override
            @Nullable
            public Collection<JavaImport> getRequiredImports() {
                return toReturn.getRequiredImports();
            }
        };
    }

    @NotNull
    public static JavaExpression callConstructorOf(final @NotNull JavaClass javaClass, final JavaExpression ... parameters) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return sg.javaMethodCall("new " + javaClass.getTypeName(), parameters);
            }

            @Override
            @Nullable
            public Collection<JavaImport> getRequiredImports() {
                return javaClass.getRequiredImports();
            }
        };
    }

    @NotNull
    public static JavaExpression thisExpression() {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return "this";
            }
        };
    }

    @NotNull
    public static JavaExpression callMethod(final @NotNull JavaMethod method, final JavaExpression ... parameters) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                if (method.isStatic()) {
                    return sg.javaStaticMethodCall(method.getParentClass(), method.getName(), parameters);
                }
                return sg.javaMethodCall(method.getName(), parameters);
            }

            @Override
            @Nullable
            public Collection<JavaImport> getRequiredImports() {
                if (method.isStatic() && method.getParentClass().getRequiredImports() != null) {
                    ArrayList<JavaImport> imports = new ArrayList<JavaImport>(method.getParentClass().getRequiredImports());
                    imports.addAll(JavaExpression.collectImports(parameters));
                    return imports;
                }
                return JavaExpression.collectImports(parameters);
            }
        };
    }

    @NotNull
    public static JavaExpression classInstanceOfClass(final @NotNull JavaClass javaClass) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return javaClass.getName() + ".class";
            }

            @Override
            @Nullable
            public Collection<JavaImport> getRequiredImports() {
                return javaClass.getRequiredImports();
            }
        };
    }

    @NotNull
    public static JavaExpression publicStaticVariable(final JavaVariable variable) {
        return new JavaExpression(){

            @Override
            @NotNull
            public String getExprString(@NotNull JavaSourceGeneratorHelper sg) {
                return variable.parentClass.getName() + "." + variable.getExprString(sg);
            }

            @Override
            @Nullable
            public Collection<JavaImport> getRequiredImports() {
                return variable.parentClass.getRequiredImports();
            }
        };
    }

    @NotNull
    private static Collection<JavaImport> collectImports(JavaExpression ... expressions) {
        ArrayList<JavaImport> imports = new ArrayList<JavaImport>();
        for (JavaExpression parameter : expressions) {
            if (parameter.getRequiredImports() == null) continue;
            imports.addAll(parameter.getRequiredImports());
        }
        return imports;
    }

    @NotNull
    public String getExprString(@NotNull JavaSourceGeneratorHelper var1);

    @Nullable
    default public Collection<JavaImport> getRequiredImports() {
        return null;
    }

    @Override
    default public void write(@NotNull Appendable writer, @NotNull GeneratorState<JavaSourceGeneratorHelper> codeState) throws IOException {
        writer.append(codeState.getIndent()).append(this.getExprString(codeState.getSg()));
    }
}

