/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import de.linusdev.lutils.codegen.GeneratorState;
import de.linusdev.lutils.codegen.PartGenerator;
import de.linusdev.lutils.codegen.java.JavaAnnotateable;
import de.linusdev.lutils.codegen.java.JavaAnnotation;
import de.linusdev.lutils.codegen.java.JavaClass;
import de.linusdev.lutils.codegen.java.JavaClassType;
import de.linusdev.lutils.codegen.java.JavaDocGenerator;
import de.linusdev.lutils.codegen.java.JavaDocable;
import de.linusdev.lutils.codegen.java.JavaEnumMemberGenerator;
import de.linusdev.lutils.codegen.java.JavaExpression;
import de.linusdev.lutils.codegen.java.JavaFileState;
import de.linusdev.lutils.codegen.java.JavaMethodGenerator;
import de.linusdev.lutils.codegen.java.JavaPackage;
import de.linusdev.lutils.codegen.java.JavaSourceGeneratorHelper;
import de.linusdev.lutils.codegen.java.JavaVariable;
import de.linusdev.lutils.codegen.java.JavaVisibility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassGenerator
implements JavaClass,
PartGenerator<JavaSourceGeneratorHelper>,
JavaAnnotateable,
JavaDocable {
    @NotNull
    protected final JavaFileState ft;
    @NotNull
    protected final JavaSourceGeneratorHelper sg;
    @NotNull
    protected final JavaPackage jPackage;
    @Nullable
    protected final JavaClassGenerator parent;
    @NotNull
    protected JavaVisibility visibility = JavaVisibility.PUBLIC;
    protected boolean isStatic = false;
    @NotNull
    protected JavaClassType type = JavaClassType.CLASS;
    @Nullable
    protected String name = null;
    @Nullable
    protected JavaClass extendedClass = null;
    @NotNull
    protected @NotNull JavaClass @NotNull [] implementedClasses = new JavaClass[0];
    @Nullable
    protected JavaDocGenerator javaDoc = null;
    @NotNull
    protected List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
    @NotNull
    protected List<JavaVariable> variables = new ArrayList<JavaVariable>();
    @NotNull
    protected List<JavaMethodGenerator> methods = new ArrayList<JavaMethodGenerator>();
    @NotNull
    protected List<JavaClassGenerator> subClasses = new ArrayList<JavaClassGenerator>();
    @NotNull
    protected List<JavaEnumMemberGenerator> enumMembers = new ArrayList<JavaEnumMemberGenerator>();

    public JavaClassGenerator(@NotNull JavaFileState ft, @NotNull JavaSourceGeneratorHelper sg, @NotNull JavaPackage jPackage, @Nullable JavaClassGenerator parent) {
        this.ft = ft;
        this.sg = sg;
        this.jPackage = jPackage;
        this.parent = parent;
    }

    @NotNull
    public JavaEnumMemberGenerator addEnumMember(@NotNull String name, JavaExpression ... parameters) {
        JavaEnumMemberGenerator e = new JavaEnumMemberGenerator(this.ft, name, parameters);
        this.enumMembers.add(e);
        return e;
    }

    @NotNull
    public JavaClassGenerator addSubClass(boolean isStatic) {
        JavaClassGenerator clazz = new JavaClassGenerator(this.ft, this.sg, this.jPackage, this);
        clazz.setStatic(isStatic);
        this.subClasses.add(clazz);
        return clazz;
    }

    @NotNull
    public JavaVariable addVariable(@NotNull JavaClass type, @NotNull String name) {
        JavaVariable variable = new JavaVariable(this.ft, this, type, name);
        this.ft.addImport(type.getRequiredImports());
        this.variables.add(variable);
        return variable;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public void setType(@NotNull JavaClassType type) {
        this.type = type;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public void setVisibility(@NotNull JavaVisibility visibility) {
        this.visibility = visibility;
    }

    public void setExtendedClass(@Nullable JavaClass extendedClass) {
        if (extendedClass != null && (extendedClass.isPrimitive() || extendedClass.isArray())) {
            throw new IllegalStateException("Cannot extend a primitive or array.");
        }
        if (extendedClass != null) {
            this.ft.addImport(extendedClass.getRequiredImports());
        }
        this.extendedClass = extendedClass;
    }

    public void setImplementedClasses(@NotNull @NotNull JavaClass @NotNull [] implementedClasses) {
        for (JavaClass implementedClass : implementedClasses) {
            if (implementedClass.isPrimitive() || implementedClass.isArray()) {
                throw new IllegalStateException("Cannot implement a primitive or array.");
            }
            this.ft.addImport(implementedClass.getRequiredImports());
        }
        this.implementedClasses = implementedClasses;
    }

    @Override
    @NotNull
    public JavaAnnotation addAnnotation(@NotNull JavaClass annotationClass) {
        JavaAnnotation annotation = new JavaAnnotation(this.ft, annotationClass);
        this.annotations.add(annotation);
        return annotation;
    }

    public JavaMethodGenerator addMethod(@NotNull JavaClass returnType, @NotNull String name) {
        JavaMethodGenerator method = new JavaMethodGenerator(this.ft, this, returnType, name);
        this.methods.add(method);
        return method;
    }

    public JavaMethodGenerator addGetter(@NotNull JavaVariable variable) {
        JavaMethodGenerator method = new JavaMethodGenerator(this.ft, this, variable.type, "get" + variable.name.substring(0, 1).toUpperCase(Locale.ROOT) + variable.name.substring(1));
        method.body(block -> block.addExpression(JavaExpression.returnExpr(variable)));
        this.methods.add(method);
        return method;
    }

    public JavaMethodGenerator addConstructor() {
        JavaMethodGenerator method = new JavaMethodGenerator(this.ft, this, this, "");
        method.setConstructor(true);
        this.methods.add(method);
        return method;
    }

    @Override
    @NotNull
    public JavaPackage getPackage() {
        return this.jPackage;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.name == null) {
            throw new IllegalStateException("Class name must be set.");
        }
        if (this.parent != null) {
            return this.parent.getName() + "." + this.name;
        }
        return this.name;
    }

    @Override
    public void write(@NotNull Appendable writer, @NotNull GeneratorState<JavaSourceGeneratorHelper> state) throws IOException {
        if (this.name == null) {
            throw new IllegalStateException("Class name must not be null.");
        }
        if (this.javaDoc != null) {
            this.javaDoc.write(writer, state);
        }
        for (JavaAnnotation annotation : this.annotations) {
            writer.append(state.getIndent()).append(this.sg.javaAnnotation(annotation)).append(this.sg.javaLineBreak());
        }
        writer.append(state.getIndent()).append(this.sg.javaClassOpenExpression(this.visibility, this.isStatic, this.type, this.name, this.extendedClass, this.implementedClasses)).append(this.sg.javaLineBreak()).append(this.sg.javaLineBreak());
        state.increaseIndent();
        if (this.type == JavaClassType.ENUM) {
            for (JavaEnumMemberGenerator enumMember : this.enumMembers) {
                enumMember.write(writer, state);
                writer.append(",").append(this.sg.javaLineBreak());
            }
            writer.append(state.getIndent()).append(this.sg.javaExpressionEnd()).append(this.sg.javaLineBreak()).append(this.sg.javaLineBreak());
        }
        for (JavaVariable variable : this.variables) {
            variable.write(writer, state);
            writer.append(this.sg.javaExpressionEnd());
            writer.append(this.sg.javaLineBreak());
        }
        writer.append(this.sg.javaLineBreak());
        for (JavaMethodGenerator method : this.methods) {
            method.write(writer, state);
            writer.append(this.sg.javaLineBreak()).append(this.sg.javaLineBreak());
        }
        for (JavaClassGenerator subClass : this.subClasses) {
            subClass.write(writer, state);
            writer.append(this.sg.javaLineBreak()).append(this.sg.javaLineBreak());
        }
        state.decreaseIndent();
        writer.append(state.getIndent()).append(this.sg.javaClassEndExpression());
    }

    @Override
    @NotNull
    public JavaDocGenerator setJavaDoc() {
        if (this.javaDoc == null) {
            this.javaDoc = new JavaDocGenerator();
        }
        return this.javaDoc;
    }
}

