/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.c;

import de.linusdev.lutils.codegen.FileGenerator;
import de.linusdev.lutils.codegen.GeneratorState;
import de.linusdev.lutils.codegen.c.CPPFileType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPFileGenerator
implements FileGenerator {
    @NotNull
    private String path = "";
    @Nullable
    private String name;
    @Nullable
    private CPPFileType type;
    @NotNull
    private final List<String> includes = new ArrayList<String>();
    @NotNull
    private final List<String> code = new ArrayList<String>();

    public void addCode(@NotNull String code) {
        this.code.add(code);
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public void setPath(@NotNull String path) {
        this.path = path;
    }

    public void setType(@Nullable CPPFileType type) {
        this.type = type;
    }

    public void addInclude(@NotNull String include) {
        if (this.includes.contains(include)) {
            return;
        }
        this.includes.add(include);
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public CPPFileType getType() {
        return this.type;
    }

    @Override
    public void write(@NotNull Appendable writer) throws IOException {
        GeneratorState<Object> state = new GeneratorState<Object>("    ", new Object());
        for (String include : this.includes) {
            writer.append("\n#include ");
            if (include.startsWith("<")) {
                writer.append(include);
                continue;
            }
            writer.append("\"").append(include).append("\"");
        }
        for (String c : this.code) {
            writer.append(c);
        }
    }
}

