/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.struct.utils;

import de.linusdev.lutils.struct.utils.Utils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class BufferUtils {
    private static final long BUFFER_VARIABLE_ADDRESS_OFFSET;

    @NotNull
    public static ByteBuffer createAligned(int capacity, long alignment) {
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)((long)capacity + alignment - 1L));
        long address = BufferUtils.getHeapAddress(buffer);
        if (address % alignment == 0L) {
            buffer.position(0);
            buffer.limit(capacity);
            return buffer.slice().order(ByteOrder.nativeOrder());
        }
        buffer.position((int)(alignment - address % alignment));
        buffer.limit(buffer.position() + capacity);
        return buffer.slice().order(ByteOrder.nativeOrder());
    }

    public static long getHeapAddress(@NotNull ByteBuffer buffer) {
        return Utils.UNSAFE.getLong(buffer, BUFFER_VARIABLE_ADDRESS_OFFSET);
    }

    @NotNull
    public static String readString(@NotNull ByteBuffer str, boolean endsWithZero) {
        if (endsWithZero) {
            str.limit(str.limit() - 1);
            str = str.slice();
        }
        return StandardCharsets.UTF_8.decode(str).toString();
    }

    @NotNull
    public static ByteBuffer slice(@NotNull ByteBuffer buffer, int start, int length) {
        int op = buffer.position();
        int ol = buffer.limit();
        buffer.position(start);
        buffer.limit(start + length);
        ByteBuffer slice = buffer.slice();
        buffer.position(op);
        buffer.limit(ol);
        return slice;
    }

    static {
        try {
            BUFFER_VARIABLE_ADDRESS_OFFSET = Utils.UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

