/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.struct.array;

import de.linusdev.lutils.struct.abstracts.Structure;
import de.linusdev.lutils.struct.annos.FixedLength;
import de.linusdev.lutils.struct.annos.StructureSettings;
import de.linusdev.lutils.struct.array.ArrayStructureInfo;
import de.linusdev.lutils.struct.array.NativeArray;
import de.linusdev.lutils.struct.generator.Language;
import de.linusdev.lutils.struct.generator.StaticGenerator;
import de.linusdev.lutils.struct.info.StructureInfo;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, requiresFixedLengthAnnotation=true)
public class PrimitiveTypeArray<T>
extends Structure
implements NativeArray<T> {
    @NotNull
    public static final PrimitiveArrayStaticGenerator GENERATOR = new PrimitiveArrayStaticGenerator();
    @NotNull
    private final ArrayStructureInfo info;
    private final int elementSize;
    private final int size;
    private final IntFunction<T> get;
    private final ObjIntConsumer<T> set;

    public PrimitiveTypeArray(@NotNull Class<T> type, int size, boolean allocateBuffer) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("You should pass the Class<> of the Wrapper not the primitive type. For example 'Integer.class', NOT 'int.class'");
        }
        try {
            Field bytes = type.getDeclaredField("BYTES");
            this.elementSize = bytes.getInt(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(type.getSimpleName() + " is not a primitive type or not supported!");
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        this.size = size;
        if (type.equals(Integer.class)) {
            this.get = index -> this.byteBuf.getInt(index);
            this.set = (value, index) -> this.byteBuf.putInt(index, (Integer)value);
        } else if (type.equals(Float.class)) {
            this.get = index -> Float.valueOf(this.byteBuf.getFloat(index));
            this.set = (value, index) -> this.byteBuf.putFloat(index, ((Float)value).floatValue());
        } else if (type.equals(Double.class)) {
            this.get = index -> this.byteBuf.getDouble(index);
            this.set = (value, index) -> this.byteBuf.putDouble(index, (Double)value);
        } else if (type.equals(Short.class)) {
            this.get = index -> this.byteBuf.getShort(index);
            this.set = (value, index) -> this.byteBuf.putShort(index, (Short)value);
        } else if (type.equals(Long.class)) {
            this.get = index -> this.byteBuf.getLong(index);
            this.set = (value, index) -> this.byteBuf.putLong(index, (Long)value);
        } else if (type.equals(Byte.class)) {
            this.get = index -> this.byteBuf.get(index);
            this.set = (value, index) -> this.byteBuf.put(index, (Byte)value);
        } else {
            throw new IllegalArgumentException("primitive type " + type.getSimpleName() + "is not supported");
        }
        this.info = GENERATOR.calculateInfo(this.elementSize, type, size);
        if (allocateBuffer) {
            this.allocate();
        }
    }

    private int toByteIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException(index);
        }
        return index * this.elementSize;
    }

    @Override
    public T get(int index) {
        return this.get.apply(this.toByteIndex(index));
    }

    @Override
    public void set(int index, T value) {
        this.set.accept(value, this.toByteIndex(index));
    }

    @Override
    public int length() {
        return this.size;
    }

    public int getInt(int index) {
        return this.byteBuf.getInt(this.toByteIndex(index));
    }

    public float getFloat(int index) {
        return this.byteBuf.getFloat(this.toByteIndex(index));
    }

    public double getDouble(int index) {
        return this.byteBuf.getDouble(this.toByteIndex(index));
    }

    public long getLong(int index) {
        return this.byteBuf.getLong(this.toByteIndex(index));
    }

    public short getShort(int index) {
        return this.byteBuf.getShort(this.toByteIndex(index));
    }

    public byte getByte(int index) {
        return this.byteBuf.get(this.toByteIndex(index));
    }

    public void setInt(int index, int value) {
        this.byteBuf.putInt(this.toByteIndex(index), value);
    }

    public void setFloat(int index, float value) {
        this.byteBuf.putFloat(this.toByteIndex(index), value);
    }

    public void setDouble(int index, double value) {
        this.byteBuf.putDouble(this.toByteIndex(index), value);
    }

    public void setLong(int index, long value) {
        this.byteBuf.putLong(this.toByteIndex(index), value);
    }

    public void setShort(int index, short value) {
        this.byteBuf.putShort(this.toByteIndex(index), value);
    }

    public void setByte(int index, byte value) {
        this.byteBuf.put(this.toByteIndex(index), value);
    }

    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < PrimitiveTypeArray.this.size;
            }

            @Override
            public T next() {
                return PrimitiveTypeArray.this.get(this.index++);
            }
        };
    }

    @Override
    @NotNull
    public StructureInfo getInfo() {
        return this.info;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("length=").append(this.length()).append("\n");
        sb.append("items={\n    ");
        for (T item : this) {
            sb.append(item).append(", ");
        }
        sb.append("\n}");
        return this.toString("StructureArray<" + this.info.elementClass.getSimpleName() + ">", sb.toString());
    }

    public static class PrimitiveArrayStaticGenerator
    implements StaticGenerator {
        @Override
        @NotNull
        public ArrayStructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable FixedLength fixedLength) {
            int elementSize;
            assert (fixedLength != null);
            Class<?> type = fixedLength.elementTypes()[0];
            if (type.isPrimitive()) {
                throw new IllegalArgumentException("You should pass the Class<> of the Wrapper not the primitive type. For example 'Integer.class', NOT 'int.class'");
            }
            try {
                Field bytes = type.getDeclaredField("BYTES");
                elementSize = bytes.getInt(null);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(type.getSimpleName() + " is not a primitive type or not supported!");
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            return this.calculateInfo(elementSize, type, fixedLength.value()[0]);
        }

        @NotNull
        public ArrayStructureInfo calculateInfo(int elementSize, @NotNull Class<?> elementClass, int length) {
            return new ArrayStructureInfo(elementSize, false, elementSize * length, elementClass, length);
        }

        @Override
        @NotNull
        public String getStructTypeName(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info) {
            ArrayStructureInfo arrayInfo = (ArrayStructureInfo)info;
            return language.getPrimitiveElementTypeName(arrayInfo.elementClass) + "[]";
        }

        @Override
        @NotNull
        public String getStructVarDef(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info, @NotNull String varName) {
            ArrayStructureInfo arrayInfo = (ArrayStructureInfo)info;
            return language.getPrimitiveElementTypeName(arrayInfo.elementClass) + " " + varName + "[" + arrayInfo.length + "]" + language.lineEnding;
        }
    }
}

