/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.struct.abstracts;

import de.linusdev.lutils.struct.abstracts.NativeParsable;
import de.linusdev.lutils.struct.generator.Language;
import de.linusdev.lutils.struct.generator.StaticGenerator;
import de.linusdev.lutils.struct.info.StructureInfo;
import de.linusdev.lutils.struct.utils.BufferUtils;
import de.linusdev.lutils.struct.utils.SSMUtils;
import de.linusdev.lutils.struct.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Structure
implements NativeParsable {
    protected Structure mostParentStructure;
    protected ByteBuffer byteBuf;
    protected int offset;
    protected volatile boolean modified;

    @NotNull
    public static String generateStructCode(@NotNull Language language, @NotNull Class<? extends Structure> structClass) {
        StructureInfo info;
        StaticGenerator generator = SSMUtils.getGenerator(structClass, null);
        String code = generator.generateStructCode(language, structClass, info = SSMUtils.getInfo(structClass, null, null, generator));
        if (code == null) {
            throw new IllegalArgumentException("Structure '" + structClass.getCanonicalName() + "' cannot generate struct code.");
        }
        return code;
    }

    protected void useBuffer(@NotNull Structure mostParentStructure, int offset) {
        this.mostParentStructure = mostParentStructure;
        this.offset = offset;
        this.byteBuf = offset == 0 ? mostParentStructure.getByteBuffer().order(ByteOrder.nativeOrder()) : BufferUtils.slice(mostParentStructure.getByteBuffer(), offset, this.getRequiredSize()).order(ByteOrder.nativeOrder());
    }

    protected void callUseBufferOf(@NotNull Structure structure, @NotNull Structure mostParentStructure, int offset) {
        structure.useBuffer(mostParentStructure, offset);
    }

    protected void claimBuffer(@NotNull ByteBuffer buffer) {
        this.mostParentStructure = this;
        this.offset = 0;
        this.byteBuf = buffer.order(ByteOrder.nativeOrder());
    }

    public void allocate() {
        this.claimBuffer(BufferUtils.createAligned(this.getRequiredSize(), 8L));
        this.useBuffer(this, 0);
    }

    @NotNull
    public abstract StructureInfo getInfo();

    @Override
    public int getAlignment() {
        return this.getInfo().getAlignment();
    }

    @Override
    public int getRequiredSize() {
        return this.getInfo().getRequiredSize();
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuf;
    }

    @Override
    public boolean isInitialised() {
        return this.byteBuf != null;
    }

    protected String toString(@NotNull String name, @Nullable String content) {
        return String.format("%s (alignment=%d, size=%d, offsetStart=%d, offsetEnd=%d) %s", name, this.getAlignment(), this.getRequiredSize(), this.getOffset(), this.getOffset() + this.getRequiredSize(), content == null ? "" : "{\n" + Utils.indent(content, "    ") + "\n}");
    }

    public void modified(int offset, int size) {
        this.mostParentStructure.onModification(offset, size);
    }

    public void modified() {
        this.modified(this.offset, this.getRequiredSize());
    }

    public void unmodified() {
        this.modified = false;
    }

    public boolean isModified() {
        return this.modified;
    }

    protected void onModification(int offset, int size) {
        this.modified = true;
    }

    public Structure getMostParentStructure() {
        return this.mostParentStructure;
    }
}

