/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.matrix.buffer;

import de.linusdev.lutils.struct.info.StructureInfo;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BBMatrixInfo
extends StructureInfo {
    @NotNull
    private final String elementTypeName;
    protected final int width;
    protected final int height;

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static BBMatrixInfo create(int width, int height, int elementSize, @NotNull String elementTypeName) {
        int size = width * height * elementSize;
        int postPadding = (elementSize - size % elementSize) % elementSize;
        return new BBMatrixInfo(elementSize, false, 0, size, postPadding, elementTypeName, width, height);
    }

    public BBMatrixInfo(int alignment, boolean compressed, int prePadding, int size, int postPadding, @NotNull String elementTypeName, int width, int height) {
        super(alignment, compressed, prePadding, size, postPadding);
        this.elementTypeName = elementTypeName;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

