/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.matrix;

import de.linusdev.lutils.math.vector.Vector;
import org.jetbrains.annotations.NotNull;

public interface Matrix
extends Vector {
    @NotNull
    public static <M extends Matrix> String toString(@NotNull M matrix, @NotNull String name, @NotNull MatrixGetter<M> getter) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(matrix.getWidth()).append("x").append(matrix.getHeight()).append(":\n[\n");
        for (int y = 0; y < matrix.getHeight(); ++y) {
            for (int x = 0; x < matrix.getWidth(); ++x) {
                sb.append(String.format(" % 10.2f ", ((Number)getter.get(matrix, y, x)).doubleValue()));
            }
            if (y == matrix.getHeight() - 1) continue;
            sb.append("\n");
        }
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    default public int getMemberCount() {
        return this.getWidth() * this.getHeight();
    }

    default public int positionToIndex(int y, int x) {
        return y * this.getWidth() + x;
    }

    public int getWidth();

    public int getHeight();

    @Override
    public boolean isArrayBacked();

    @Override
    public boolean isBufferBacked();

    @Override
    default public boolean isView() {
        return false;
    }

    @FunctionalInterface
    public static interface MatrixGetter<M extends Matrix> {
        @NotNull
        public Object get(@NotNull M var1, int var2, int var3);
    }
}

