/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math;

import de.linusdev.lutils.math.matrix.Matrix;
import de.linusdev.lutils.math.matrix.abstracts.floatn.Float3x3;
import de.linusdev.lutils.math.matrix.abstracts.floatn.Float4x4;
import de.linusdev.lutils.math.matrix.abstracts.floatn.FloatMxN;
import de.linusdev.lutils.math.vector.Vector;
import de.linusdev.lutils.math.vector.abstracts.floatn.Float3;
import de.linusdev.lutils.math.vector.abstracts.floatn.Float4;
import de.linusdev.lutils.math.vector.abstracts.floatn.FloatN;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class VMath {
    public static boolean equals(@NotNull FloatN vector, float @NotNull [] data, float epsilon) {
        if (vector.getMemberCount() != data.length) {
            return false;
        }
        for (int i = 0; i < data.length; ++i) {
            if (!(Math.abs(vector.get(i) - data[i]) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull FloatN vector, @NotNull FloatN other, float epsilon) {
        if (vector.getMemberCount() != other.getMemberCount()) {
            return false;
        }
        for (int i = 0; i < vector.getMemberCount(); ++i) {
            if (!(Math.abs(vector.get(i) - other.get(i)) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull FloatMxN matrix, float @NotNull [] data, float epsilon) {
        if (matrix.getWidth() * matrix.getHeight() != data.length) {
            return false;
        }
        for (int y = 0; y < matrix.getHeight(); ++y) {
            for (int x = 0; x < matrix.getWidth(); ++x) {
                if (!(Math.abs(matrix.get(y, x) - data[y * matrix.getWidth() + x]) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(@NotNull FloatMxN matrix, @NotNull FloatMxN other, float epsilon) {
        if (matrix.getWidth() != other.getWidth() || matrix.getHeight() != other.getHeight()) {
            return false;
        }
        for (int y = 0; y < matrix.getHeight(); ++y) {
            for (int x = 0; x < matrix.getWidth(); ++x) {
                if (!(Math.abs(matrix.get(y, x) - other.get(y, x)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V add(@NotNull V left, @NotNull V right, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(left, right, store));
        assert (VMath.uniqueViewVector(store, left, right));
        for (int i = 0; i < left.getMemberCount(); ++i) {
            store.put(i, left.get(i) + right.get(i));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V subtract(@NotNull V left, @NotNull V right, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(left, right, store));
        assert (VMath.uniqueViewVector(store, left, right));
        for (int i = 0; i < left.getMemberCount(); ++i) {
            store.put(i, left.get(i) - right.get(i));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V multiply(@NotNull V left, @NotNull V right, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(left, right, store));
        assert (VMath.uniqueViewVector(store, left, right));
        for (int i = 0; i < left.getMemberCount(); ++i) {
            store.put(i, left.get(i) * right.get(i));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V divide(@NotNull V left, @NotNull V right, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(left, right, store));
        assert (VMath.uniqueViewVector(store, left, right));
        for (int i = 0; i < left.getMemberCount(); ++i) {
            store.put(i, left.get(i) / right.get(i));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <V extends FloatN> V scale(@NotNull V toScale, float factor, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(toScale, store));
        assert (VMath.uniqueViewVector(store, toScale));
        for (int i = 0; i < toScale.getMemberCount(); ++i) {
            store.put(i, toScale.get(i) * factor);
        }
        return store;
    }

    public static float dot(@NotNull FloatN left, @NotNull FloatN right) {
        assert (VMath.matchingDimensions(left, right));
        float dot = 0.0f;
        for (int i = 0; i < left.getMemberCount(); ++i) {
            dot += left.get(i) * right.get(i);
        }
        return dot;
    }

    public static float length(@NotNull FloatN vector) {
        float length = 0.0f;
        for (int i = 0; i < vector.getMemberCount(); ++i) {
            length += vector.get(i) * vector.get(i);
        }
        return (float)Math.sqrt(length);
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static Float3 cross(@NotNull Float3 left, @NotNull Float3 right, @NotNull Float3 store) {
        float storeX = left.get(1) * right.get(2) - left.get(2) * right.get(1);
        float storeY = left.get(2) * right.get(0) - left.get(0) * right.get(2);
        float storeZ = left.get(0) * right.get(1) - left.get(1) * right.get(0);
        store.xyz(storeX, storeY, storeZ);
        return store;
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static <V extends FloatN> V normalize(@NotNull V toNormalize, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(toNormalize, store));
        assert (VMath.uniqueViewVector(store, toNormalize));
        float length = VMath.length(toNormalize);
        length = length == 0.0f ? 1.0f : length;
        for (int i = 0; i < toNormalize.getMemberCount(); ++i) {
            store.put(i, toNormalize.get(i) / length);
        }
        return store;
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static <V extends FloatN> V absolute(@NotNull V toAbsolute, @UniqueView @NotNull V store) {
        assert (VMath.matchingDimensions(toAbsolute, store));
        assert (VMath.uniqueViewVector(store, toAbsolute));
        for (int i = 0; i < toAbsolute.getMemberCount(); ++i) {
            store.put(i, Math.abs(toAbsolute.get(i)));
        }
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static <M extends FloatMxN> M scale(@NotNull M toScale, float factor, @UniqueView @NotNull M store) {
        assert (VMath.matchingDimensions(toScale, store));
        for (int x = 0; x < toScale.getWidth(); ++x) {
            for (int y = 0; y < toScale.getHeight(); ++y) {
                store.put(y, x, toScale.get(y, x) * factor);
            }
        }
        return store;
    }

    public static float determinant(@NotNull Float4x4 mat) {
        return 0.0f + mat.get(0, 0) * mat.get(1, 1) * mat.get(2, 2) * mat.get(3, 3) + mat.get(0, 0) * mat.get(1, 2) * mat.get(2, 3) * mat.get(3, 1) + mat.get(0, 0) * mat.get(1, 3) * mat.get(2, 1) * mat.get(3, 2) - mat.get(0, 0) * mat.get(1, 3) * mat.get(2, 2) * mat.get(3, 1) - mat.get(0, 0) * mat.get(1, 2) * mat.get(2, 1) * mat.get(3, 3) - mat.get(0, 0) * mat.get(1, 1) * mat.get(2, 3) * mat.get(3, 2) - mat.get(0, 1) * mat.get(1, 0) * mat.get(2, 2) * mat.get(3, 3) - mat.get(0, 2) * mat.get(1, 0) * mat.get(2, 3) * mat.get(3, 1) - mat.get(0, 3) * mat.get(1, 0) * mat.get(2, 1) * mat.get(3, 2) + mat.get(0, 3) * mat.get(1, 0) * mat.get(2, 2) * mat.get(3, 1) + mat.get(0, 2) * mat.get(1, 0) * mat.get(2, 1) * mat.get(3, 3) + mat.get(0, 1) * mat.get(1, 0) * mat.get(2, 3) * mat.get(3, 2) + mat.get(0, 1) * mat.get(1, 2) * mat.get(2, 0) * mat.get(3, 3) + mat.get(0, 2) * mat.get(1, 3) * mat.get(2, 0) * mat.get(3, 1) + mat.get(0, 3) * mat.get(1, 1) * mat.get(2, 0) * mat.get(3, 2) - mat.get(0, 3) * mat.get(1, 2) * mat.get(2, 0) * mat.get(3, 1) - mat.get(0, 2) * mat.get(1, 1) * mat.get(2, 0) * mat.get(3, 3) - mat.get(0, 1) * mat.get(1, 3) * mat.get(2, 0) * mat.get(3, 2) - mat.get(0, 1) * mat.get(1, 2) * mat.get(2, 3) * mat.get(3, 0) - mat.get(0, 2) * mat.get(1, 3) * mat.get(2, 1) * mat.get(3, 0) - mat.get(0, 3) * mat.get(1, 1) * mat.get(2, 2) * mat.get(3, 0) + mat.get(0, 3) * mat.get(1, 2) * mat.get(2, 1) * mat.get(3, 0) + mat.get(0, 2) * mat.get(1, 1) * mat.get(2, 3) * mat.get(3, 0) + mat.get(0, 1) * mat.get(1, 3) * mat.get(2, 2) * mat.get(3, 0);
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static Float4x4 adjugate(@NotNull Float4x4 mat, @Unique @NotNull Float4x4 store) {
        assert (VMath.uniqueMatrix(store, mat));
        store.put(0, 0, 0.0f + mat.get(1, 1) * mat.get(2, 2) * mat.get(3, 3) + mat.get(1, 2) * mat.get(2, 3) * mat.get(3, 1) + mat.get(1, 3) * mat.get(2, 1) * mat.get(3, 2) - mat.get(1, 3) * mat.get(2, 2) * mat.get(3, 1) - mat.get(1, 2) * mat.get(2, 1) * mat.get(3, 3) - mat.get(1, 1) * mat.get(2, 3) * mat.get(3, 2));
        store.put(1, 0, 0.0f - mat.get(1, 0) * mat.get(2, 2) * mat.get(3, 3) - mat.get(1, 2) * mat.get(2, 3) * mat.get(3, 0) - mat.get(1, 3) * mat.get(2, 0) * mat.get(3, 2) + mat.get(1, 3) * mat.get(2, 2) * mat.get(3, 0) + mat.get(1, 2) * mat.get(2, 0) * mat.get(3, 3) + mat.get(1, 0) * mat.get(2, 3) * mat.get(3, 2));
        store.put(2, 0, 0.0f + mat.get(1, 0) * mat.get(2, 1) * mat.get(3, 3) + mat.get(1, 1) * mat.get(2, 3) * mat.get(3, 0) + mat.get(1, 3) * mat.get(2, 0) * mat.get(3, 1) - mat.get(1, 3) * mat.get(2, 1) * mat.get(3, 0) - mat.get(1, 1) * mat.get(2, 0) * mat.get(3, 3) - mat.get(1, 0) * mat.get(2, 3) * mat.get(3, 1));
        store.put(3, 0, 0.0f - mat.get(1, 0) * mat.get(2, 1) * mat.get(3, 2) - mat.get(1, 1) * mat.get(2, 2) * mat.get(3, 0) - mat.get(1, 2) * mat.get(2, 0) * mat.get(3, 1) + mat.get(1, 2) * mat.get(2, 1) * mat.get(3, 0) + mat.get(1, 1) * mat.get(2, 0) * mat.get(3, 2) + mat.get(1, 0) * mat.get(2, 2) * mat.get(3, 1));
        store.put(0, 1, 0.0f - mat.get(0, 1) * mat.get(2, 2) * mat.get(3, 3) - mat.get(0, 2) * mat.get(2, 3) * mat.get(3, 1) - mat.get(0, 3) * mat.get(2, 1) * mat.get(3, 2) + mat.get(0, 3) * mat.get(2, 2) * mat.get(3, 1) + mat.get(0, 2) * mat.get(2, 1) * mat.get(3, 3) + mat.get(0, 1) * mat.get(2, 3) * mat.get(3, 2));
        store.put(1, 1, 0.0f + mat.get(0, 0) * mat.get(2, 2) * mat.get(3, 3) + mat.get(0, 2) * mat.get(2, 3) * mat.get(3, 0) + mat.get(0, 3) * mat.get(2, 0) * mat.get(3, 2) - mat.get(0, 3) * mat.get(2, 2) * mat.get(3, 0) - mat.get(0, 2) * mat.get(2, 0) * mat.get(3, 3) - mat.get(0, 0) * mat.get(2, 3) * mat.get(3, 2));
        store.put(2, 1, 0.0f - mat.get(0, 0) * mat.get(2, 1) * mat.get(3, 3) - mat.get(0, 1) * mat.get(2, 3) * mat.get(3, 0) - mat.get(0, 3) * mat.get(2, 0) * mat.get(3, 1) + mat.get(0, 3) * mat.get(2, 1) * mat.get(3, 0) + mat.get(0, 1) * mat.get(2, 0) * mat.get(3, 3) + mat.get(0, 0) * mat.get(2, 3) * mat.get(3, 1));
        store.put(3, 1, 0.0f + mat.get(0, 0) * mat.get(2, 1) * mat.get(3, 2) + mat.get(0, 1) * mat.get(2, 2) * mat.get(3, 0) + mat.get(0, 2) * mat.get(2, 0) * mat.get(3, 1) - mat.get(0, 2) * mat.get(2, 1) * mat.get(3, 0) - mat.get(0, 1) * mat.get(2, 0) * mat.get(3, 2) - mat.get(0, 0) * mat.get(2, 2) * mat.get(3, 1));
        store.put(0, 2, 0.0f + mat.get(0, 1) * mat.get(1, 2) * mat.get(3, 3) + mat.get(0, 2) * mat.get(1, 3) * mat.get(3, 1) + mat.get(0, 3) * mat.get(1, 1) * mat.get(3, 2) - mat.get(0, 3) * mat.get(1, 2) * mat.get(3, 1) - mat.get(0, 2) * mat.get(1, 1) * mat.get(3, 3) - mat.get(0, 1) * mat.get(1, 3) * mat.get(3, 2));
        store.put(1, 2, 0.0f - mat.get(0, 0) * mat.get(1, 2) * mat.get(3, 3) - mat.get(0, 2) * mat.get(1, 3) * mat.get(3, 0) - mat.get(0, 3) * mat.get(1, 0) * mat.get(3, 2) + mat.get(0, 3) * mat.get(1, 2) * mat.get(3, 0) + mat.get(0, 2) * mat.get(1, 0) * mat.get(3, 3) + mat.get(0, 0) * mat.get(1, 3) * mat.get(3, 2));
        store.put(2, 2, 0.0f + mat.get(0, 0) * mat.get(1, 1) * mat.get(3, 3) + mat.get(0, 1) * mat.get(1, 3) * mat.get(3, 0) + mat.get(0, 3) * mat.get(1, 0) * mat.get(3, 1) - mat.get(0, 3) * mat.get(1, 1) * mat.get(3, 0) - mat.get(0, 1) * mat.get(1, 0) * mat.get(3, 3) - mat.get(0, 0) * mat.get(1, 3) * mat.get(3, 1));
        store.put(3, 2, 0.0f - mat.get(0, 0) * mat.get(1, 1) * mat.get(3, 2) - mat.get(0, 1) * mat.get(1, 2) * mat.get(3, 0) - mat.get(0, 2) * mat.get(1, 0) * mat.get(3, 1) + mat.get(0, 2) * mat.get(1, 1) * mat.get(3, 0) + mat.get(0, 1) * mat.get(1, 0) * mat.get(3, 2) + mat.get(0, 0) * mat.get(1, 2) * mat.get(3, 1));
        store.put(0, 3, 0.0f - mat.get(0, 1) * mat.get(1, 2) * mat.get(2, 3) - mat.get(0, 2) * mat.get(1, 3) * mat.get(2, 1) - mat.get(0, 3) * mat.get(1, 1) * mat.get(2, 2) + mat.get(0, 3) * mat.get(1, 2) * mat.get(2, 1) + mat.get(0, 2) * mat.get(1, 1) * mat.get(2, 3) + mat.get(0, 1) * mat.get(1, 3) * mat.get(2, 2));
        store.put(1, 3, 0.0f + mat.get(0, 0) * mat.get(1, 2) * mat.get(2, 3) + mat.get(0, 2) * mat.get(1, 3) * mat.get(2, 0) + mat.get(0, 3) * mat.get(1, 0) * mat.get(2, 2) - mat.get(0, 3) * mat.get(1, 2) * mat.get(2, 0) - mat.get(0, 2) * mat.get(1, 0) * mat.get(2, 3) - mat.get(0, 0) * mat.get(1, 3) * mat.get(2, 2));
        store.put(2, 3, 0.0f - mat.get(0, 0) * mat.get(1, 1) * mat.get(2, 3) - mat.get(0, 1) * mat.get(1, 3) * mat.get(2, 0) - mat.get(0, 3) * mat.get(1, 0) * mat.get(2, 1) + mat.get(0, 3) * mat.get(1, 1) * mat.get(2, 0) + mat.get(0, 1) * mat.get(1, 0) * mat.get(2, 3) + mat.get(0, 0) * mat.get(1, 3) * mat.get(2, 1));
        store.put(3, 3, 0.0f + mat.get(0, 0) * mat.get(1, 1) * mat.get(2, 2) + mat.get(0, 1) * mat.get(1, 2) * mat.get(2, 0) + mat.get(0, 2) * mat.get(1, 0) * mat.get(2, 1) - mat.get(0, 2) * mat.get(1, 1) * mat.get(2, 0) - mat.get(0, 1) * mat.get(1, 0) * mat.get(2, 2) - mat.get(0, 0) * mat.get(1, 2) * mat.get(2, 1));
        return store;
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static Float4x4 inverse(@NotNull Float4x4 mat, @Unique @NotNull Float4x4 store) {
        assert (VMath.uniqueMatrix(store, mat));
        return VMath.scale(VMath.adjugate(mat, store), 1.0f / VMath.determinant(mat), store);
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static Float4 multiply(@NotNull Float4x4 left, @NotNull Float4 right, @NotNull Float4 store) {
        float storeX = 0.0f + right.get(0) * left.get(0, 0) + right.get(1) * left.get(0, 1) + right.get(2) * left.get(0, 2) + right.get(3) * left.get(0, 3);
        float storeY = 0.0f + right.get(0) * left.get(1, 0) + right.get(1) * left.get(1, 1) + right.get(2) * left.get(1, 2) + right.get(3) * left.get(1, 3);
        float storeZ = 0.0f + right.get(0) * left.get(2, 0) + right.get(1) * left.get(2, 1) + right.get(2) * left.get(2, 2) + right.get(3) * left.get(2, 3);
        float storeW = 0.0f + right.get(0) * left.get(3, 0) + right.get(1) * left.get(3, 1) + right.get(2) * left.get(3, 2) + right.get(3) * left.get(3, 3);
        store.xyzw(storeX, storeY, storeZ, storeW);
        return store;
    }

    @Contract(value="_, _, _ -> param3")
    @NotNull
    public static Float3 multiply(@NotNull Float3x3 left, @NotNull Float3 right, @NotNull Float3 store) {
        float storeX = 0.0f + right.get(0) * left.get(0, 0) + right.get(1) * left.get(0, 1) + right.get(2) * left.get(0, 2);
        float storeY = 0.0f + right.get(0) * left.get(1, 0) + right.get(1) * left.get(1, 1) + right.get(2) * left.get(1, 2);
        float storeZ = 0.0f + right.get(0) * left.get(2, 0) + right.get(1) * left.get(2, 1) + right.get(2) * left.get(2, 2);
        store.xyz(storeX, storeY, storeZ);
        return store;
    }

    private static boolean matchingDimensions(Vector ... vectors) {
        int dim = vectors[0].getMemberCount();
        for (int i = 1; i < vectors.length; ++i) {
            if (vectors[i].getMemberCount() == dim) continue;
            return false;
        }
        return true;
    }

    private static boolean matchingDimensions(Matrix ... matrices) {
        int width = matrices[0].getWidth();
        int height = matrices[0].getHeight();
        for (int i = 1; i < matrices.length; ++i) {
            if (matrices[i].getWidth() == width && matrices[i].getHeight() == height) continue;
            return false;
        }
        return true;
    }

    private static boolean uniqueVector(@NotNull Vector unique, Vector ... vectors) {
        Vector original = unique.isView() ? unique.getAsView().getOriginal() : unique;
        for (int i = 0; i < vectors.length; ++i) {
            if (original != (vectors[i].isView() ? vectors[i].getAsView().getOriginal() : vectors[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean uniqueViewVector(@NotNull Vector unique, Vector ... vectors) {
        if (unique.isView()) {
            Object original = unique.getAsView().getOriginal();
            boolean isUniqueMappingSpecial = Vector.View.isMappingSpecial(unique);
            int[] defaultMapping = unique.getAsView().getMapping();
            for (int i = 0; i < vectors.length; ++i) {
                if (vectors[i].isView() && original == vectors[i].getAsView().getOriginal() && Vector.View.isMappingSpecial(defaultMapping, vectors[i])) {
                    return false;
                }
                if (vectors[i].isView() || vectors[i] != original || !isUniqueMappingSpecial) continue;
                return false;
            }
        } else {
            for (int i = 0; i < vectors.length; ++i) {
                if (!vectors[i].isView() || unique != vectors[i].getAsView().getOriginal() || !Vector.View.isMappingSpecial(vectors[i])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean uniqueMatrix(@NotNull Matrix unique, Matrix ... matrices) {
        for (int i = 0; i < matrices.length; ++i) {
            if (unique != matrices[i]) continue;
            return false;
        }
        return true;
    }

    private VMath() {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface UniqueView {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Unique {
    }
}

