/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.http.body;

import de.linusdev.lutils.http.body.BodyParser;
import de.linusdev.lutils.http.header.HeaderMap;
import de.linusdev.lutils.http.header.HeaderNames;
import de.linusdev.lutils.http.header.value.BasicHeaderValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BodyParsers {
    private BodyParsers() {
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static BodyParser<String> newStringBodyParser() {
        return new BodyParser<String>(){

            @Override
            @NotNull
            public String parse(@NotNull HeaderMap headers, @NotNull InputStream in) throws IOException {
                String line;
                BasicHeaderValue contentType = headers.get(HeaderNames.CONTENT_TYPE).parseValue(BasicHeaderValue.PARSER);
                String charset = contentType.get("charset");
                if (charset == null) {
                    charset = StandardCharsets.UTF_8.name();
                }
                InputStreamReader inReader = new InputStreamReader(in, charset);
                BufferedReader reader = new BufferedReader(inReader);
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                return sb.toString();
            }
        };
    }
}

