/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.http;

import de.linusdev.lutils.http.body.Body;
import de.linusdev.lutils.http.header.Header;
import de.linusdev.lutils.http.header.HeaderMap;
import de.linusdev.lutils.http.header.HeaderName;
import de.linusdev.lutils.http.header.value.HeaderValue;
import de.linusdev.lutils.http.method.Methods;
import de.linusdev.lutils.http.method.RequestMethod;
import de.linusdev.lutils.http.version.HTTPVersion;
import de.linusdev.lutils.http.version.HTTPVersions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTTPRequestBuilder {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final byte[] LINE_SEPARATOR = "\r\n".getBytes(CHARSET);
    public static final byte SPACE = 32;
    @NotNull
    private RequestMethod method;
    @Nullable
    private String path;
    @NotNull
    private HTTPVersion version;
    @NotNull
    private HeaderMap headers = new HeaderMap();
    @Nullable
    private Body body;

    public HTTPRequestBuilder() {
        this.version = HTTPVersions.HTTP_1_1;
        this.method = Methods.GET;
    }

    public HTTPRequestBuilder setMethod(@NotNull RequestMethod method) {
        this.method = method;
        return this;
    }

    public HTTPRequestBuilder setPath(@Nullable String path) {
        this.path = path;
        return this;
    }

    public HTTPRequestBuilder setVersion(@NotNull HTTPVersion version) {
        this.version = version;
        return this;
    }

    public HTTPRequestBuilder setBody(@Nullable Body body) {
        if (this.body != null) {
            this.body.removeHeaders(this.headers);
        }
        this.body = body;
        if (this.body != null) {
            this.body.adjustHeaders(this.headers);
        }
        return this;
    }

    public HTTPRequestBuilder setHeader(@NotNull String key, @Nullable String value) {
        if (value == null) {
            this.headers.remove(key);
        } else {
            this.headers.put(key, Header.of(key, value));
        }
        return this;
    }

    public HTTPRequestBuilder setHeader(@NotNull Header header) {
        this.headers.put(header);
        return this;
    }

    public HTTPRequestBuilder setHeader(@NotNull HeaderName name, @Nullable String value) {
        if (value == null) {
            this.headers.remove(name.getName());
        } else {
            this.headers.put(name.with(value));
        }
        return this;
    }

    public HTTPRequestBuilder setHeader(@NotNull HeaderName name, @Nullable HeaderValue value) {
        if (value == null) {
            this.headers.remove(name.getName());
        } else {
            this.headers.put(name.with(value));
        }
        return this;
    }

    public HTTPRequestBuilder setHeaders(@NotNull HeaderMap headers) {
        this.headers = headers;
        return this;
    }

    public HTTPRequestBuilder GET(@Nullable String path) {
        this.setMethod(Methods.GET);
        this.setPath(path);
        return this;
    }

    public HTTPRequestBuilder POST(@Nullable String path, @NotNull Body body) {
        this.setMethod(Methods.POST);
        this.setPath(path);
        this.setBody(body);
        return this;
    }

    public String build() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.build(stream);
        return stream.toString(StandardCharsets.UTF_8);
    }

    public void build(@NotNull OutputStream stream) throws IOException {
        this.build(stream, 2048);
    }

    public void build(@NotNull OutputStream stream, int maxBufferSize) throws IOException {
        stream.write(this.method.getName().getBytes(CHARSET));
        stream.write(32);
        if (this.path != null) {
            stream.write(this.path.getBytes(CHARSET));
            stream.write(32);
        }
        stream.write(this.version.asString().getBytes(CHARSET));
        stream.write(LINE_SEPARATOR);
        for (Header header : this.headers.values()) {
            stream.write(header.asString().getBytes(CHARSET));
            stream.write(LINE_SEPARATOR);
        }
        stream.write(LINE_SEPARATOR);
        if (this.body != null) {
            byte[] buffer = this.body.length() == -1 ? new byte[maxBufferSize] : new byte[Math.min(this.body.length(), maxBufferSize)];
            try (InputStream bodyStream = this.body.stream();){
                int len;
                while ((len = bodyStream.read(buffer)) != -1) {
                    stream.write(buffer, 0, len);
                }
            }
        }
    }
}

