/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.async;

import de.linusdev.lutils.async.Future;
import de.linusdev.lutils.async.Task;
import de.linusdev.lutils.async.consumer.ResultAndErrorConsumer;
import de.linusdev.lutils.async.consumer.ResultConsumer;
import de.linusdev.lutils.async.consumer.SingleResultConsumer;
import de.linusdev.lutils.async.error.AsyncError;
import de.linusdev.lutils.async.error.MessageError;
import de.linusdev.lutils.async.error.StandardErrorTypes;
import de.linusdev.lutils.async.error.ThrowableAsyncError;
import de.linusdev.lutils.async.exception.CannotQueueTaskException;
import de.linusdev.lutils.async.exception.ErrorException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PTask<R, S>
extends Task<R, S> {
    @NotNull
    public Future<R, S> consumeAndQueue(@Nullable Consumer<Future<R, S>> var1) throws CannotQueueTaskException;

    @Override
    @NotNull
    default public Future<R, S> queue() {
        return this.consumeAndQueue(null);
    }

    @Override
    @NotNull
    default public Future<R, S> queueAndSetBeforeExecutionListener(@NotNull Consumer<Future<R, S>> consumer) {
        return this.consumeAndQueue(future -> future.beforeExecution(consumer));
    }

    @Override
    @NotNull
    default public Future<R, S> queue(@NotNull ResultConsumer<R, S> consumer) {
        return this.consumeAndQueue(future -> future.then(consumer));
    }

    @Override
    @NotNull
    default public Future<R, S> queue(@NotNull SingleResultConsumer<R, S> consumer) {
        return this.consumeAndQueue(future -> future.then(consumer));
    }

    @Override
    @NotNull
    default public Future<R, S> queue(@NotNull ResultAndErrorConsumer<R, S> consumer) {
        return this.consumeAndQueue(future -> future.then(consumer));
    }

    @Override
    @NotNull
    default public R queueAndWait() throws InterruptedException, ErrorException {
        return this.queue().getResult();
    }

    @Override
    @NotNull
    default public Future<R, S> queueAndWriteToFile(@NotNull Path file, boolean overwriteIfExists, @Nullable ResultAndErrorConsumer<R, S> after) {
        return this.queue((R result, S secondary, AsyncError error) -> {
            block7: {
                if (error != null) {
                    if (after != null) {
                        after.onError(error, this, secondary);
                    }
                    return;
                }
                if (Files.exists(file, new LinkOption[0]) && !overwriteIfExists) {
                    if (after != null) {
                        after.onError(new MessageError("File " + String.valueOf(file) + " already exists.", StandardErrorTypes.FILE_ALREADY_EXISTS), this, secondary);
                    }
                    return;
                }
                try {
                    Files.deleteIfExists(file);
                    Files.writeString(file, (CharSequence)Objects.toString(result), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                    if (after != null) {
                        after.consume(result, secondary);
                    }
                }
                catch (IOException e) {
                    if (after == null) break block7;
                    after.onError(new ThrowableAsyncError(e), this, secondary);
                }
            }
        });
    }
}

