/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.struct.info;

import de.linusdev.lutils.struct.abstracts.ComplexStructure;
import de.linusdev.lutils.struct.abstracts.Structure;
import de.linusdev.lutils.struct.annos.FixedLength;
import de.linusdev.lutils.struct.annos.StructValue;
import de.linusdev.lutils.struct.exception.IllegalStructVarException;
import de.linusdev.lutils.struct.info.StructureInfo;
import de.linusdev.lutils.struct.utils.SSMUtils;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructVarInfo {
    @NotNull
    protected final StructValue structValue;
    @Nullable
    protected final FixedLength fixedLength;
    @NotNull
    protected final Class<? extends Structure> clazz;
    @NotNull
    protected final String varName;
    @NotNull
    protected final StructureInfo info;
    @NotNull
    protected final Field field;

    @Nullable
    public static StructVarInfo ofField(@NotNull Field field) {
        @NotNull Class<?> fieldClass = field.getType();
        StructValue sv = field.getAnnotation(StructValue.class);
        FixedLength fl = field.getAnnotation(FixedLength.class);
        if (sv == null) {
            return null;
        }
        StructureInfo info = SSMUtils.getInfo(fieldClass, fl, field, null);
        return new StructVarInfo(sv, fl, fieldClass, field.getName(), info, field);
    }

    public StructVarInfo(@NotNull StructValue structValue, @Nullable FixedLength fixedLength, @NotNull Class<? extends Structure> clazz, @NotNull String varName, @NotNull StructureInfo info, @NotNull Field field) {
        this.structValue = structValue;
        this.fixedLength = fixedLength;
        this.clazz = clazz;
        this.varName = varName;
        this.info = info;
        this.field = field;
    }

    @NotNull
    public StructValue getStructValue() {
        return this.structValue;
    }

    @Nullable
    public FixedLength getFixedLength() {
        return this.fixedLength;
    }

    @NotNull
    public Class<? extends Structure> getClazz() {
        return this.clazz;
    }

    @NotNull
    public String getVarName() {
        return this.varName;
    }

    @NotNull
    public StructureInfo getInfo() {
        return this.info;
    }

    public Structure get(@NotNull ComplexStructure instance) {
        try {
            return (Structure)this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw (IllegalStructVarException)new IllegalStructVarException(this.field, "Cannot access field.").initCause(e);
        }
    }
}

