/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.struct.info;

import de.linusdev.lutils.struct.abstracts.ComplexStructure;
import de.linusdev.lutils.struct.abstracts.Structure;
import de.linusdev.lutils.struct.info.StructVarInfo;
import de.linusdev.lutils.struct.info.StructureInfo;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ComplexStructureInfo
extends StructureInfo {
    @NotNull
    protected final @NotNull StructVarInfo @NotNull [] childrenInfo;

    @NotNull
    public static ComplexStructureInfo generateFromStructVars(int alignment, boolean compress, @NotNull @NotNull StructVarInfo @NotNull [] vars) {
        int[] sizes = new int[vars.length * 2 + 1];
        int padding = 0;
        int position = 0;
        int i = 0;
        while (i < vars.length) {
            StructureInfo structure = vars[i].getInfo();
            if (position % alignment == 0 || alignment - position % alignment >= structure.getRequiredSize()) {
                int itemSize = structure.getRequiredSize();
                int itemAlignment = structure.getAlignment();
                if (!compress && position % itemAlignment != 0) {
                    int offset = itemAlignment - position % itemAlignment;
                    position += offset;
                    padding += offset;
                    continue;
                }
                sizes[i * 2] = padding;
                sizes[i * 2 + 1] = itemSize;
                position += itemSize;
                padding = 0;
                ++i;
                continue;
            }
            int offset = alignment - position % alignment;
            position += offset;
            padding += offset;
        }
        if (position % alignment != 0) {
            sizes[sizes.length - 1] = alignment - position % alignment;
            position += sizes[sizes.length - 1];
        } else {
            sizes[sizes.length - 1] = 0;
        }
        return new ComplexStructureInfo(alignment, compress, position, sizes, vars);
    }

    private static int getBiggestStructAlignment(int min, int max, StructVarInfo ... vars) {
        int biggest = min;
        for (StructVarInfo structure : vars) {
            biggest = Math.max(biggest, structure.getInfo().getAlignment());
        }
        return Math.min(max, biggest);
    }

    @NotNull
    public static ComplexStructureInfo generateFromStructVars(@NotNull @NotNull StructVarInfo @NotNull [] vars) {
        return ComplexStructureInfo.generateFromStructVars(ComplexStructureInfo.getBiggestStructAlignment(4, 16, vars), false, vars);
    }

    @NotNull
    public static ComplexStructureInfo generateFromStructVars(@NotNull Class<?> clazz) {
        Field[] fields = clazz.getFields();
        StructVarInfo[] infos = new StructVarInfo[fields.length];
        int index = 0;
        int size = 0;
        for (Field field : fields) {
            StructVarInfo info = StructVarInfo.ofField(field);
            if (info == null) continue;
            if (info.getStructValue().value() == -1) {
                infos[index++] = info;
            } else {
                infos[info.getStructValue().value()] = info;
            }
            ++size;
        }
        return ComplexStructureInfo.generateFromStructVars(Arrays.copyOf(infos, size));
    }

    private ComplexStructureInfo(int alignment, boolean compress, int size, int[] sizes, @NotNull @NotNull StructVarInfo @NotNull [] infos) {
        super(alignment, compress, size, sizes);
        this.childrenInfo = infos;
    }

    @NotNull
    public @NotNull StructVarInfo @NotNull [] getChildrenInfo() {
        return this.childrenInfo;
    }

    @NotNull
    public @NotNull Structure @NotNull [] getChildren(@NotNull ComplexStructure instance) {
        Structure[] structures = new Structure[this.childrenInfo.length];
        for (int i = 0; i < structures.length; ++i) {
            structures[i] = this.childrenInfo[i].get(instance);
        }
        return structures;
    }
}

