/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.struct.generator;

import org.jetbrains.annotations.NotNull;

public enum Language {
    OPEN_CL(";"){
        private final int[] suppPaddings = new int[]{1, 2, 4, 8, 16};

        @Override
        @NotNull
        public String getStartStructString(boolean packed, @NotNull String name) {
            return packed ? "typedef struct __attribute__((packed)) {\n" : "typedef struct {\n";
        }

        @Override
        @NotNull
        public String getEndStructString(boolean packed, @NotNull String name) {
            return "} " + name + ";";
        }

        @Override
        public int addPadding(StringBuilder sb, int padding, int index) {
            switch (padding) {
                case 0: {
                    return index;
                }
                case 1: {
                    sb.append("byte padding").append(index).append(";\n");
                    break;
                }
                case 2: {
                    sb.append("char padding").append(index).append(";\n");
                    break;
                }
                case 4: {
                    sb.append("int padding").append(index).append(";\n");
                    break;
                }
                case 8: {
                    sb.append("int2 padding").append(index).append(";\n");
                    break;
                }
                case 16: {
                    sb.append("int4 padding").append(index).append(";\n");
                    break;
                }
                default: {
                    for (int i = this.suppPaddings.length - 1; i >= 0; --i) {
                        int pad = this.suppPaddings[i];
                        if (padding - pad <= 0) continue;
                        index = this.addPadding(sb, pad, index);
                        return this.addPadding(sb, padding -= pad, index);
                    }
                }
            }
            return index + 1;
        }

        @Override
        @NotNull
        public String getPrimitiveElementTypeName(@NotNull Class<?> primitiveClass) {
            if (primitiveClass.equals(Integer.class)) {
                return "int";
            }
            if (primitiveClass.equals(Float.class)) {
                return "float";
            }
            if (primitiveClass.equals(Double.class)) {
                return "double";
            }
            if (primitiveClass.equals(Short.class)) {
                return "short";
            }
            if (primitiveClass.equals(Long.class)) {
                return "long";
            }
            if (primitiveClass.equals(Byte.class) || primitiveClass.equals(Character.class)) {
                return "char";
            }
            throw new IllegalArgumentException("primitive type " + primitiveClass.getSimpleName() + "is not supported");
        }
    };

    @NotNull
    public final String lineEnding;

    private Language(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    @NotNull
    public abstract String getStartStructString(boolean var1, @NotNull String var2);

    @NotNull
    public abstract String getEndStructString(boolean var1, @NotNull String var2);

    public abstract int addPadding(StringBuilder var1, int var2, int var3);

    @NotNull
    public abstract String getPrimitiveElementTypeName(@NotNull Class<?> var1);
}

