/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.struct.array;

import de.linusdev.lutils.struct.abstracts.Structure;
import de.linusdev.lutils.struct.annos.FixedLength;
import de.linusdev.lutils.struct.annos.StructureSettings;
import de.linusdev.lutils.struct.array.ArrayStructureInfo;
import de.linusdev.lutils.struct.array.NativeArray;
import de.linusdev.lutils.struct.generator.Language;
import de.linusdev.lutils.struct.generator.StaticGenerator;
import de.linusdev.lutils.struct.info.StructureInfo;
import de.linusdev.lutils.struct.mod.ModTrackingStructure;
import de.linusdev.lutils.struct.utils.SSMUtils;
import de.linusdev.lutils.struct.utils.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, requiresFixedLengthAnnotation=true)
public class StructureArray<T extends Structure>
extends ModTrackingStructure
implements NativeArray<T> {
    @NotNull
    public static final ArrayStaticGenerator GENERATOR = new ArrayStaticGenerator();
    @NotNull
    private final StructureInfo elementInfo;
    @NotNull
    private final ArrayStructureInfo info;
    @NotNull
    private final ElementCreator<T> creator;
    private final Structure @NotNull [] items;
    private final int size;

    public StructureArray(boolean allocateBuffer, boolean trackModifications, @NotNull Class<T> elementClass, int size, @NotNull ElementCreator<T> creator) {
        super(trackModifications);
        this.elementInfo = SSMUtils.getInfo(elementClass, null, null, null);
        this.size = size;
        this.items = new Structure[size];
        this.creator = creator;
        this.info = GENERATOR.calculateInfo(this.elementInfo, elementClass, size);
        if (allocateBuffer) {
            this.allocate();
        }
    }

    @Override
    public void set(int index, @NotNull T struct) {
        this.items[index] = struct;
        this.callUseBufferOf((Structure)struct, this.mostParentStructure, this.offset + this.elementInfo.getRequiredSize() * index);
    }

    @Override
    protected void useBuffer(@NotNull Structure mostParentStructure, int offset) {
        super.useBuffer(mostParentStructure, offset);
    }

    @Override
    public int length() {
        return this.size;
    }

    @NotNull
    public T getOrCreate(int index) {
        if (this.items[index] == null) {
            this.items[index] = this.creator.create();
            T item = this.items[index];
            this.callUseBufferOf((Structure)item, this.mostParentStructure, this.offset + this.elementInfo.getRequiredSize() * index);
            return item;
        }
        return (T)this.items[index];
    }

    @Override
    public T get(int index) {
        return (T)this.items[index];
    }

    @Override
    @NotNull
    public ArrayStructureInfo getInfo() {
        return this.info;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("length=").append(this.length()).append("\n");
        sb.append("items={\n");
        int index = 0;
        for (Structure item : this.items) {
            sb.append(Utils.indent(index++ + ": " + String.valueOf(item), "    ")).append(",\n");
        }
        sb.append("}");
        return this.toString("StructureArray<" + this.info.elementClass.getSimpleName() + ">", sb.toString());
    }

    @FunctionalInterface
    public static interface ElementCreator<T extends Structure> {
        @NotNull
        public T create();
    }

    public static class ArrayStaticGenerator
    implements StaticGenerator {
        @Override
        @NotNull
        public ArrayStructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable FixedLength fixedLength) {
            assert (fixedLength != null);
            StructureInfo elementInfo = SSMUtils.getInfo(fixedLength.elementTypes()[0], null, null, null);
            return this.calculateInfo(elementInfo, fixedLength.elementTypes()[0], fixedLength.value()[0]);
        }

        @NotNull
        public ArrayStructureInfo calculateInfo(@NotNull StructureInfo elementInfo, @NotNull Class<?> elementClass, int length) {
            return new ArrayStructureInfo(elementInfo.getAlignment(), false, elementInfo.getRequiredSize() * length, elementClass, length);
        }

        @Override
        @NotNull
        public String getStructTypeName(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info) {
            ArrayStructureInfo arrayInfo = (ArrayStructureInfo)info;
            StructureInfo elementInfo = SSMUtils.getInfo(arrayInfo.elementClass, null, null, null);
            StaticGenerator elementGenerator = SSMUtils.getGenerator(arrayInfo.elementClass, null);
            return elementGenerator.getStructTypeName(language, arrayInfo.elementClass, elementInfo) + "[]";
        }

        @Override
        @NotNull
        public String getStructVarDef(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info, @NotNull String varName) {
            ArrayStructureInfo arrayInfo = (ArrayStructureInfo)info;
            StructureInfo elementInfo = SSMUtils.getInfo(arrayInfo.elementClass, null, null, null);
            StaticGenerator elementGenerator = SSMUtils.getGenerator(arrayInfo.elementClass, null);
            return elementGenerator.getStructTypeName(language, arrayInfo.elementClass, elementInfo) + " " + varName + "[" + arrayInfo.length + "]" + language.lineEnding;
        }
    }
}

