/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.struct.abstracts;

import de.linusdev.lutils.struct.abstracts.Structure;
import de.linusdev.lutils.struct.annos.FixedLength;
import de.linusdev.lutils.struct.annos.StructureSettings;
import de.linusdev.lutils.struct.generator.Language;
import de.linusdev.lutils.struct.generator.StaticGenerator;
import de.linusdev.lutils.struct.info.ComplexStructureInfo;
import de.linusdev.lutils.struct.info.StructVarInfo;
import de.linusdev.lutils.struct.info.StructureInfo;
import de.linusdev.lutils.struct.mod.ModTrackingStructure;
import de.linusdev.lutils.struct.utils.SSMUtils;
import de.linusdev.lutils.struct.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true)
public abstract class ComplexStructure
extends ModTrackingStructure {
    protected Structure[] items;
    @NotNull
    private static final Map<Class<?>, ComplexStructureInfo> INFO_MAP = new HashMap();
    @NotNull
    private static final Object INFO_MAP_LOCK = new Object();
    @NotNull
    public static final StaticGenerator GENERATOR = new StaticGenerator(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ComplexStructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable FixedLength fixedLength) {
            Object object = INFO_MAP_LOCK;
            synchronized (object) {
                ComplexStructureInfo info = INFO_MAP.get(selfClazz);
                if (info == null) {
                    info = ComplexStructureInfo.generateFromStructVars(selfClazz);
                    INFO_MAP.put(selfClazz, info);
                }
                return info;
            }
        }

        @Override
        @NotNull
        public String generateStructCode(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info) {
            ComplexStructureInfo cInfo = (ComplexStructureInfo)info;
            StringBuilder sb = new StringBuilder();
            int @NotNull [] sizes = cInfo.getSizes();
            @NotNull StructVarInfo @NotNull [] childrenInfo = cInfo.getChildrenInfo();
            int paddingIndex = 0;
            sb.append(language.getStartStructString(true, this.getStructTypeName(language, selfClazz, info)));
            for (int i = 0; i < sizes.length; ++i) {
                String text;
                if (sizes[i] == 0) continue;
                if ((i - 1) % 2 == 0) {
                    StructVarInfo childInfo = childrenInfo[(i - 1) / 2];
                    StaticGenerator childGenerator = SSMUtils.getGenerator(childInfo.getClazz(), null);
                    text = childGenerator.getStructVarDef(language, childInfo.getClazz(), childInfo.getInfo(), childInfo.getVarName());
                } else {
                    StringBuilder pad = new StringBuilder();
                    paddingIndex = language.addPadding(pad, sizes[i], paddingIndex);
                    text = pad.toString();
                }
                sb.append(Utils.indent(text, "    ")).append("\n");
            }
            sb.append(language.getEndStructString(true, this.getStructTypeName(language, selfClazz, info)));
            return sb.toString();
        }

        @Override
        @NotNull
        public String getStructTypeName(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info) {
            String name = selfClazz.getSimpleName();
            if (name.endsWith("Struct")) {
                name = name.substring(0, name.length() - "Struct".length());
            }
            if (name.endsWith("Structure")) {
                name = name.substring(0, name.length() - "Structure".length());
            }
            return name;
        }
    };

    public ComplexStructure(boolean trackModifications) {
        super(trackModifications);
    }

    protected void init(boolean allocateBuffer, Structure ... items) {
        Structure[] structureArray = this.items = items.length == 0 ? this.getInfo().getChildren(this) : items;
        if (allocateBuffer) {
            this.allocate();
        }
    }

    @Override
    protected void useBuffer(@NotNull Structure mostParentStructure, int offset) {
        super.useBuffer(mostParentStructure, offset);
        if (this.items == null) {
            return;
        }
        ComplexStructureInfo info = this.getInfo();
        int[] sizes = info.getSizes();
        int position = 0;
        for (int i = 0; i < this.items.length; ++i) {
            position += sizes[i * 2];
            if (this.items[i] != null) {
                this.items[i].useBuffer(mostParentStructure, offset + position);
            }
            position += sizes[i * 2 + 1];
        }
    }

    @Override
    @NotNull
    public ComplexStructureInfo getInfo() {
        return (ComplexStructureInfo)GENERATOR.calculateInfo(this.getClass(), null);
    }

    public String toString() {
        ComplexStructureInfo cInfo = this.getInfo();
        StringBuilder sb = new StringBuilder();
        int @NotNull [] sizes = cInfo.getSizes();
        @NotNull StructVarInfo @NotNull [] childrenInfo = cInfo.getChildrenInfo();
        for (int i = 0; i < sizes.length; ++i) {
            String text;
            if (sizes[i] == 0) continue;
            if ((i - 1) % 2 == 0) {
                StructVarInfo childInfo = childrenInfo[(i - 1) / 2];
                text = childInfo.getVarName() + ": " + childInfo.get(this).toString() + "\n";
            } else {
                text = "padding: { size=" + sizes[i] + " }\n";
            }
            sb.append(Utils.indent(text, "    ")).append("\n");
        }
        return this.toString(GENERATOR.getStructTypeName(Language.OPEN_CL, this.getClass(), cInfo), sb.toString());
    }
}

