/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.vector;

import de.linusdev.lutils.struct.abstracts.Structure;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public interface Vector {
    @NotNull
    public static <T extends Vector> String toString(@NotNull T vector, @NotNull String elementTypeName, @NotNull BiFunction<T, Integer, Object> getter) {
        StringBuilder sb = new StringBuilder().append(elementTypeName).append(vector.getMemberCount()).append(vector.isView() ? "view" : "").append("(").append(getter.apply(vector, 0));
        for (int i = 1; i < vector.getMemberCount(); ++i) {
            sb.append(", ").append(getter.apply(vector, i));
        }
        return sb.append(")").toString();
    }

    public int getMemberCount();

    public boolean isArrayBacked();

    public boolean isBufferBacked();

    @NotNull
    default public Structure getStructure() {
        throw new UnsupportedOperationException("This vector is not buffer backed.");
    }

    public boolean isView();

    @NotNull
    default public View<?> getAsView() {
        throw new UnsupportedOperationException("This vector is not a view on another vector.");
    }

    public static abstract class View<V extends Vector>
    implements Vector {
        @NotNull
        protected final V original;
        protected final int @NotNull [] mapping;

        static int @NotNull [] recalculateMappingToOriginal(@NotNull View<?> view, int @NotNull [] mapping) {
            int[] viewMapping = view.getMapping();
            int[] newMapping = new int[mapping.length];
            for (int i = 0; i < mapping.length; ++i) {
                newMapping[i] = viewMapping[mapping[i]];
            }
            return newMapping;
        }

        public static boolean isMappingSpecial(@NotNull Vector view) {
            int[] mapping = view.getAsView().getMapping();
            for (int i = 0; i < mapping.length; ++i) {
                if (i == mapping[i]) continue;
                return true;
            }
            return false;
        }

        public static boolean isMappingSpecial(int @NotNull [] defaultMapping, @NotNull Vector viewToCheck) {
            int[] mapping = viewToCheck.getAsView().getMapping();
            for (int i = 0; i < mapping.length; ++i) {
                if (defaultMapping[i] == mapping[i]) continue;
                return true;
            }
            return defaultMapping.length != mapping.length;
        }

        protected View(@NotNull V original, int @NotNull [] mapping) {
            if (original.isView()) {
                mapping = View.recalculateMappingToOriginal(original.getAsView(), mapping);
                original = original.getAsView().getOriginal();
            }
            this.original = original;
            this.mapping = mapping;
        }

        @NotNull
        public V getOriginal() {
            return this.original;
        }

        public int @NotNull [] getMapping() {
            return this.mapping;
        }

        @Override
        public boolean isArrayBacked() {
            return false;
        }

        @Override
        public boolean isBufferBacked() {
            return false;
        }

        @Override
        public boolean isView() {
            return true;
        }

        public abstract boolean hasFactor();

        @NotNull
        public Object getFactor() {
            throw new UnsupportedOperationException("This view has no factor");
        }

        @NotNull
        public View<V> getAsView() {
            return this;
        }
    }
}

