/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.matrix.buffer.floatn;

import de.linusdev.lutils.math.matrix.Matrix;
import de.linusdev.lutils.math.matrix.abstracts.floatn.FloatMxN;
import de.linusdev.lutils.math.matrix.buffer.BBMatrixInfo;
import de.linusdev.lutils.struct.abstracts.Structure;
import de.linusdev.lutils.struct.generator.Language;
import de.linusdev.lutils.struct.generator.StaticGenerator;
import de.linusdev.lutils.struct.info.StructureInfo;
import java.nio.FloatBuffer;
import org.jetbrains.annotations.NotNull;

public abstract class BBFloatMxN
extends Structure
implements FloatMxN {
    @NotNull
    public static final StaticGenerator GENERATOR = new StaticGenerator(){

        @Override
        @NotNull
        public String getStructTypeName(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info) {
            BBMatrixInfo bbInfo = (BBMatrixInfo)info;
            return bbInfo.getElementTypeName() + bbInfo.getHeight() + "x" + bbInfo.getWidth();
        }

        @Override
        @NotNull
        public String getStructVarDef(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info, @NotNull String varName) {
            BBMatrixInfo bbInfo = (BBMatrixInfo)info;
            return bbInfo.getElementTypeName() + " " + varName + "[" + bbInfo.getHeight() * bbInfo.getWidth() + "]" + language.lineEnding;
        }
    };
    protected FloatBuffer buf;

    public BBFloatMxN(boolean allocateBuffer) {
        if (allocateBuffer) {
            this.allocate();
        }
    }

    @Override
    public void useBuffer(@NotNull Structure mostParentStructure, int offset) {
        super.useBuffer(mostParentStructure, offset);
        this.buf = this.byteBuf.asFloatBuffer();
    }

    @Override
    public float get(int y, int x) {
        return this.buf.get(this.positionToIndex(y, x));
    }

    @Override
    public void put(int y, int x, float value) {
        this.buf.put(this.positionToIndex(y, x), value);
    }

    @Override
    public float get(int index) {
        return this.buf.get(index);
    }

    @Override
    public void put(int index, float value) {
        this.buf.put(index, value);
    }

    @Override
    @NotNull
    public Structure getStructure() {
        return this;
    }

    @Override
    public boolean isArrayBacked() {
        return false;
    }

    @Override
    public boolean isBufferBacked() {
        return true;
    }

    public String toString() {
        return this.toString("float" + this.getWidth() + "x" + this.getHeight(), Matrix.toString(this, "float", BBFloatMxN::get));
    }
}

