/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.http.body;

import de.linusdev.lutils.http.header.HeaderMap;
import de.linusdev.lutils.http.header.HeaderNames;
import de.linusdev.lutils.http.header.contenttype.ContentType;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Body {
    @Nullable
    public ContentType contentType();

    public int length();

    default public int definitiveLength() {
        int n;
        block10: {
            if (this.length() != -1) {
                return this.length();
            }
            InputStream stream = this.stream();
            try {
                int len;
                byte[] buffer = new byte[2048];
                int actualLength = 0;
                while ((len = stream.read(buffer)) != -1) {
                    actualLength += len;
                }
                n = actualLength;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot calculate length of this body.");
                }
            }
            stream.close();
        }
        return n;
    }

    default public void adjustHeaders(@NotNull HeaderMap headers) {
        ContentType contentType = this.contentType();
        if (contentType != null) {
            headers.put(contentType.asHeader());
        }
        headers.put(HeaderNames.CONTENT_LENGTH.with("" + this.definitiveLength()));
    }

    default public void removeHeaders(@NotNull HeaderMap headers) {
        ContentType contentType = this.contentType();
        if (contentType != null && headers.containsValue(contentType.asHeader())) {
            headers.remove(HeaderNames.CONTENT_TYPE);
        }
        if (headers.containsValue(HeaderNames.CONTENT_LENGTH.with("" + this.length()))) {
            headers.remove(HeaderNames.CONTENT_LENGTH);
        }
    }

    @NotNull
    public InputStream stream();
}

