/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class HTTPRequestReader
implements AutoCloseable {
    @NotNull
    private final InputStream in;
    private int position;
    private int limit;
    private final byte[] buffer;
    private final ByteBuffer bufferObject;
    private final CharsetDecoder decoder;
    private final char[] charBuffer;
    private final CharBuffer charBufferObject;
    private final CharBuffer decodeCharBufferObject;
    @NotNull
    private final CharRet charRet = new CharRet();
    @NotNull
    private final LineReader lineReader = new LineReader();

    public HTTPRequestReader(@NotNull InputStream in) {
        this.in = in;
        this.buffer = new byte[2048];
        this.bufferObject = ByteBuffer.wrap(this.buffer);
        this.decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        this.charBuffer = new char[512];
        this.charBufferObject = CharBuffer.wrap(this.charBuffer);
        this.decodeCharBufferObject = this.charBufferObject.subSequence(0, this.charBufferObject.capacity() - 1);
        this.charBufferObject.limit(0);
    }

    private void readToBuffer() throws IOException {
        this.position = 0;
        this.limit = this.in.read(this.buffer);
        System.out.println("readToBuffer: limit: " + this.limit);
    }

    public int read() throws IOException {
        if (this.position >= this.limit) {
            this.readToBuffer();
        }
        if (this.limit < 0) {
            return -1;
        }
        return Byte.toUnsignedInt(this.buffer[this.position++]);
    }

    private boolean readToCharBuffer() throws IOException {
        CoderResult result;
        if (this.position >= this.limit) {
            this.readToBuffer();
        }
        if (this.limit < 0) {
            return false;
        }
        this.bufferObject.position(this.position);
        this.bufferObject.limit(this.limit);
        this.charBufferObject.clear();
        this.decodeCharBufferObject.clear();
        System.out.println("Start decoding");
        do {
            System.out.println("decode: endOFInput: " + (this.limit != this.buffer.length) + ", limit: " + this.limit + ", buffer.length: " + this.buffer.length);
            result = this.decoder.decode(this.bufferObject, this.decodeCharBufferObject, this.limit != this.buffer.length);
            if (!result.isMalformed() && !result.isUnmappable()) continue;
            this.bufferObject.position(this.bufferObject.position() + result.length());
            if (result.length() == 1) {
                this.charBufferObject.append('?');
                continue;
            }
            if (result.length() == 2) {
                this.charBufferObject.append('?').append('?');
                continue;
            }
            if (result.length() == 3) {
                this.charBufferObject.append('\ufffd');
                continue;
            }
            this.charBufferObject.append('\ufffd').append('?');
        } while (result.isError());
        this.charBufferObject.position(this.decodeCharBufferObject.position());
        this.charBufferObject.limit(this.decodeCharBufferObject.limit());
        if (this.limit != this.buffer.length) {
            this.charBufferObject.limit(this.charBufferObject.capacity());
            if (this.decoder.flush(this.charBufferObject).isOverflow()) {
                throw new InternalError("Decoder.flush() is trying to write more than 1 char!");
            }
        }
        this.charBufferObject.flip();
        return true;
    }

    @NotNull
    public CharRet readChar() throws IOException {
        System.out.println("charBufferObject.remaining(): " + this.charBufferObject.remaining());
        if (this.charBufferObject.remaining() == 0) {
            boolean a = this.readToCharBuffer();
            System.out.println("readToCharBuffer(): " + a);
            if (!a) {
                return this.charRet.eof();
            }
        }
        System.out.println("before charBufferObject.get():  cbo.pos:" + this.charBufferObject.position() + ", cbo.limit: " + this.charBufferObject.limit());
        this.charRet.character = this.charBufferObject.get();
        if (this.charRet.highSurrogate) {
            this.charRet.highSurrogate = false;
        } else if (this.charRet.character < '\u0080') {
            ++this.position;
        } else if (this.charRet.character < '\u0800') {
            this.position += 2;
        } else if (Character.isHighSurrogate(this.charRet.character)) {
            this.charRet.highSurrogate = true;
            this.position += 4;
        } else {
            this.position += 3;
        }
        return this.charRet;
    }

    @NotNull
    public LineReader getLineReader() {
        return this.lineReader;
    }

    @NotNull
    public InputStream getInputStreamForRemaining() {
        final HTTPRequestReader this_ = this;
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (HTTPRequestReader.this.position < HTTPRequestReader.this.limit) {
                    return Byte.toUnsignedInt(HTTPRequestReader.this.buffer[HTTPRequestReader.this.position++]);
                }
                return HTTPRequestReader.this.in.read();
            }

            @Override
            public int read(byte @NotNull [] dst, int off, int len) throws IOException {
                int copyLen = 0;
                if (HTTPRequestReader.this.position < HTTPRequestReader.this.limit) {
                    copyLen = Math.min(len, HTTPRequestReader.this.limit - HTTPRequestReader.this.position);
                    System.arraycopy(HTTPRequestReader.this.buffer, HTTPRequestReader.this.position, dst, off, copyLen);
                    HTTPRequestReader.this.position += copyLen;
                }
                if (copyLen < len) {
                    int furtherReadLen = HTTPRequestReader.this.in.read(dst, off + copyLen, len - copyLen);
                    if (furtherReadLen == -1 && copyLen == 0) {
                        return -1;
                    }
                    copyLen += Math.max(0, furtherReadLen);
                }
                return copyLen;
            }

            @Override
            public void close() throws IOException {
                this_.close();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static class CharRet {
        public boolean eof = false;
        public char character = '\u0000';
        public boolean highSurrogate = false;

        public CharRet eof() {
            this.eof = true;
            return this;
        }
    }

    public class LineReader {
        public boolean eof = false;
        public boolean eol = false;

        private void updateState(@NotNull StringBuilder sb) {
            this.eof = HTTPRequestReader.this.charRet.eof;
            this.eol = HTTPRequestReader.this.charRet.character == '\n';
            sb.setLength(sb.length() - (this.eol && sb.length() >= 2 && sb.charAt(sb.length() - 2) == '\r' ? 2 : 1));
        }

        @NotNull
        public String readUntil(char c) throws IOException {
            StringBuilder sb = new StringBuilder();
            do {
                HTTPRequestReader.this.readChar();
                sb.append(HTTPRequestReader.this.charRet.character);
            } while (HTTPRequestReader.this.charRet.character != c && HTTPRequestReader.this.charRet.character != '\n' && !HTTPRequestReader.this.charRet.eof);
            this.updateState(sb);
            return sb.toString();
        }

        @NotNull
        public String readUntilLineFeed() throws IOException {
            StringBuilder sb = new StringBuilder();
            do {
                HTTPRequestReader.this.readChar();
                sb.append(HTTPRequestReader.this.charRet.character);
            } while (HTTPRequestReader.this.charRet.character != '\n' && !HTTPRequestReader.this.charRet.eof);
            this.updateState(sb);
            return sb.toString();
        }
    }
}

