/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.http;

import de.linusdev.lutils.http.HTTPRequestBuilder;
import de.linusdev.lutils.http.HTTPRequestReader;
import de.linusdev.lutils.http.body.BodyParser;
import de.linusdev.lutils.http.header.Header;
import de.linusdev.lutils.http.header.HeaderMap;
import de.linusdev.lutils.http.method.RequestMethod;
import de.linusdev.lutils.http.version.HTTPVersion;
import de.linusdev.lutils.http.version.HTTPVersions;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTTPRequest<B> {
    @NotNull
    private final RequestMethod method;
    @Nullable
    private final String path;
    @NotNull
    private final HTTPVersion version;
    @NotNull
    private final HeaderMap headers;
    @Nullable
    private final B body;

    public HTTPRequest(@NotNull RequestMethod method, @Nullable String path, @NotNull HTTPVersion version, @NotNull HeaderMap headers, @Nullable B body) {
        this.method = method;
        this.path = path;
        this.version = version;
        this.headers = headers;
        this.body = body;
    }

    @NotNull
    public static <B> HTTPRequest<B> parse(@NotNull InputStream in, @NotNull BodyParser<B> parser) throws IOException {
        String key;
        HTTPVersion version;
        String path;
        HTTPRequestReader reader = new HTTPRequestReader(in);
        HTTPRequestReader.LineReader lineReader = reader.getLineReader();
        HeaderMap headers = new HeaderMap();
        RequestMethod method = RequestMethod.of(lineReader.readUntil(' '));
        if (lineReader.eol) {
            throw new IllegalArgumentException("Malformed HTTP request. Missing HTTP version.");
        }
        String pathOrVersion = lineReader.readUntil(' ');
        if (lineReader.eol) {
            path = null;
            version = HTTPVersions.of(pathOrVersion);
        } else {
            path = pathOrVersion;
            version = HTTPVersions.of(lineReader.readUntilLineFeed());
        }
        while (!lineReader.eof && !(key = lineReader.readUntil(':')).isEmpty()) {
            if (lineReader.eol) {
                throw new IllegalArgumentException("Malformed HTTP request. Header line: " + key);
            }
            String value = lineReader.readUntilLineFeed().stripLeading();
            Header header = Header.of(key, value);
            headers.put(key, header);
        }
        B body = parser.parse(headers, reader.getInputStreamForRemaining());
        return new HTTPRequest<B>(method, path, version, headers, body);
    }

    @NotNull
    public static HTTPRequest<Void> parse(@NotNull InputStream in) throws IOException {
        return HTTPRequest.parse(in, (hs, in1) -> null);
    }

    @NotNull
    public static HTTPRequestBuilder builder() {
        return new HTTPRequestBuilder();
    }

    @NotNull
    public RequestMethod getMethod() {
        return this.method;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @NotNull
    public HTTPVersion getVersion() {
        return this.version;
    }

    @NotNull
    public HeaderMap getHeaders() {
        return this.headers;
    }

    @Nullable
    public B getBody() {
        return this.body;
    }
}

