/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.color.impl;

import de.linusdev.lutils.color.RGBAColor;

public class RGBAColorDoubleImpl
implements RGBAColor {
    private final double red;
    private final double green;
    private final double blue;
    private final double alpha;

    public RGBAColorDoubleImpl(double red, double green, double blue, double alpha) {
        if (red < 0.0 || red > 1.0 || green < 0.0 || green > 1.0 || blue < 0.0 || blue > 1.0 || alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("No color double value may be above 1.0 or below 0.0. r, g, b, a: " + red + ", " + green + ", " + blue + ", " + alpha + ".");
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    @Override
    public int getRed() {
        return (int)Math.round(255.0 * this.red);
    }

    @Override
    public int getGreen() {
        return (int)Math.round(255.0 * this.green);
    }

    @Override
    public int getBlue() {
        return (int)Math.round(255.0 * this.blue);
    }

    @Override
    public int getAlpha() {
        return (int)Math.round(255.0 * this.alpha);
    }

    @Override
    public double red() {
        return this.red;
    }

    @Override
    public double green() {
        return this.green;
    }

    @Override
    public double blue() {
        return this.blue;
    }

    @Override
    public double alpha() {
        return this.alpha;
    }

    public String toString() {
        return "(" + this.red() + ", " + this.green() + ", " + this.blue() + ", " + this.alpha() + ")";
    }
}

